/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.streams;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class EncodingUtil {
    public static final String UTF8 = "UTF-8";
    public static final String UTF16 = "UTF-16";
    public static final String ISO_8859_1 = "ISO-8859-1";
    private static final ExLogger logger = ExLogger.getExLogger(EncodingUtil.class);

    public static byte[] convertUnicodeStringToUTF8String(String source, String encoding) throws UnsupportedEncodingException {
        byte[] unicodeAsBytes = source.getBytes();
        return new String(unicodeAsBytes, encoding).getBytes(UTF8);
    }

    public static void convertUnicodeFileToUTF8File(String fileIn, String fileOut) throws IOException {
        File input = new File(fileIn);
        byte[] unicodeAsBytes = EncodingUtil.getBytesFromFile(input);
        FileOutputStream fos = new FileOutputStream(fileOut);
        String utf16String = new String(unicodeAsBytes, UTF16);
        fos.write(utf16String.getBytes(UTF8));
        fos.close();
    }

    public static void saveUTF8File(String fileOut, String utf8Text) throws IOException {
        EncodingUtil.saveUTF8File(new File(fileOut), utf8Text);
    }

    public static void saveUTF8File(File fileOut, String utf8Text) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileOut);
            fos.write(utf8Text.getBytes(UTF8));
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            fos.close();
        }
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = null;
        byte[] bytes = null;
        try {
            int offset;
            is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                throw new IOException("File is too large " + file.getName());
            }
            bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    logger.info(DescriptorConstants.GN_UnableToCloseStream, (Object)e.getMessage());
                }
            }
        }
        return bytes;
    }

    public static String decodeISO88591UsingUTF8(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new String(string.getBytes(ISO_8859_1), UTF8);
        }
        catch (UnsupportedEncodingException e) {
            return string;
        }
    }

    public static String encodeISO88591UsingUTF8(String string) {
        if (string == null) {
            return null;
        }
        try {
            String decodedString = EncodingUtil.decodeISO88591UsingUTF8(string);
            return URLEncoder.encode(decodedString, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            return string;
        }
    }

    public static String encodeFileNameForResponse(String fileName, HttpServletRequest request) {
        String encodeText;
        String userAgent = request.getHeader("User-Agent");
        try {
            if (userAgent != null && StringUtils.contains((String)userAgent.toLowerCase(), (String)"msie")) {
                String fileNameNoExtension;
                String extension;
                int index = fileName.lastIndexOf(46);
                if (-1 == index) {
                    extension = "";
                    fileNameNoExtension = fileName;
                } else {
                    extension = fileName.substring(index + 1);
                    fileNameNoExtension = fileName.substring(0, index);
                }
                encodeText = URLEncoder.encode(fileNameNoExtension, UTF8);
                encodeText = encodeText + "." + extension;
            } else {
                encodeText = MimeUtility.encodeText((String)fileName, (String)UTF8, (String)"B");
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e);
            encodeText = null;
        }
        return encodeText;
    }

    public static void main(String[] args) {
        int ndx;
        try {
            EncodingUtil.convertUnicodeFileToUTF8File("c:\\temp\\_Hebrew_index.xml", "c:\\temp\\_Hebrew_index_out.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] bRay = null;
        char quote = '\"';
        String sInitial = "Guy Ben Porat \u05d2\u05d9\u05d0 \u05d1\u05df \u05e4\u05d5\u05e8\u05ea";
        try {
            bRay = sInitial.getBytes(UTF16);
        }
        catch (UnsupportedEncodingException uee) {
            System.out.println("Exception: " + uee);
        }
        System.out.println(quote + sInitial + quote + " String as UTF-16, " + "bRay length: " + bRay.length + ".");
        for (ndx = 0; ndx < bRay.length; ++ndx) {
            System.out.print(Integer.toHexString(bRay[ndx++]) + " ");
            System.out.print(Integer.toHexString(bRay[ndx]) + "   ");
        }
        System.out.println("\n");
        OutputStreamWriter osw = new OutputStreamWriter(System.out);
        bRay = sInitial.getBytes();
        System.out.println(quote + sInitial + quote + " String as platform default - " + osw.getEncoding() + ", bRay length: " + bRay.length + ".");
        for (ndx = 0; ndx < bRay.length; ++ndx) {
            System.out.print(Integer.toHexString(bRay[ndx]) + "   ");
        }
        System.out.println("\n");
        try {
            sInitial = new String(sInitial.getBytes(UTF8), UTF8);
            bRay = sInitial.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException uee) {
            System.out.println("Exception: " + uee);
        }
        System.out.println(quote + sInitial + quote + " String as UTF-8, " + "bRay length: " + bRay.length + ".");
        for (ndx = 0; ndx < bRay.length; ++ndx) {
            System.out.print(Integer.toHexString(bRay[ndx]) + "   ");
        }
    }
}

