/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class UrlParserUtil {
    public static String parseUrl(HashMap<String, String> swapParameters, String urlTemplate) {
        if (swapParameters != null && urlTemplate != null) {
            Set<String> keys = swapParameters.keySet();
            for (String key : keys) {
                urlTemplate = StringUtils.replace((String)urlTemplate, (String)("{" + key + "}"), (String)swapParameters.get(key).trim());
            }
        }
        return urlTemplate;
    }

    public static List<String> getUrlTamplateArgs(String urlTemplate) {
        ArrayList<String> parameters = new ArrayList<String>();
        int index = 0;
        while (index != -1) {
            index = StringUtils.indexOf((String)urlTemplate, (String)"{");
            int lastIndex = StringUtils.indexOf((String)urlTemplate, (String)"}");
            if (index == -1) continue;
            String parameter = StringUtils.substring((String)urlTemplate, (int)(index + 1), (int)lastIndex);
            parameters.add(parameter);
            urlTemplate = StringUtils.substring((String)urlTemplate, (int)(lastIndex + 1));
        }
        return parameters;
    }

    public static String getValidUrl(String url) {
        return url.trim().replace("&", "&amp;");
    }

    public static String removeUrlAttribute(String url, String attriubteName) {
        StringBuffer result = new StringBuffer();
        if (url != null) {
            url = url.trim().replace("&amp;", "&");
            StringTokenizer tokenizer = new StringTokenizer(url, "?");
            String urlStart = tokenizer.nextToken();
            if (tokenizer.hasMoreElements()) {
                String urlAttributes = tokenizer.nextToken();
                result.append(urlStart).append("?");
                StringTokenizer attributesTokenizer = new StringTokenizer(urlAttributes, "&");
                while (attributesTokenizer.hasMoreElements()) {
                    String attribute = attributesTokenizer.nextToken();
                    if (attribute.contains(attriubteName)) continue;
                    if (result.toString().endsWith("?")) {
                        result.append(attribute);
                        continue;
                    }
                    result.append("&").append(attribute);
                }
            }
        }
        return result.toString();
    }
}

