/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.plugins;

import com.exlibris.core.infra.model.HOwneredEntity;
import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.core.infra.model.plugins.HFrPluginType;
import com.exlibris.core.infra.model.plugins.PluginImplType;
import com.exlibris.core.infra.model.plugins.PluginStatus;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@AttributeOverride(name="id", column=@Column(name="PLUGIN_ID"))
@Table(name="HFRPLUGIN_INSTANCE", uniqueConstraints={@UniqueConstraint(columnNames={"owner", "plugin_name"})})
public class HFrPluginInstance
extends HOwneredEntity {
    private static final long serialVersionUID = 1L;
    private HFrPluginType pluginType;
    private String pluginName;
    private String implName;
    private PluginImplType pluginImplType;
    private double pluginVersion;
    private String contactPerson;
    private Boolean isPublicApi;
    private String description;
    private PluginStatus status;
    private String configXml;
    private String contactLastName;
    private String contactFirstName;
    private String contactName;
    private String indexXml;
    private String initParmXml;
    private String jarFileName;
    private DeploymentMode deploymentMode;

    @Column(length=255, name="plugin_name")
    @Searchable
    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    @Column(length=255, name="impl_name")
    @Searchable
    public String getImplName() {
        return this.implName;
    }

    public void setImplName(String implName) {
        this.implName = implName;
    }

    @Column(length=50, name="plugin_impl_type")
    @Searchable
    public PluginImplType getPluginImplType() {
        return this.pluginImplType;
    }

    public void setPluginImplType(PluginImplType pluginImplType) {
        this.pluginImplType = pluginImplType;
    }

    @Column(name="plugin_version", columnDefinition="NUMBER")
    @Searchable
    public double getPluginVersion() {
        return this.pluginVersion;
    }

    public void setPluginVersion(double pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    @Column(name="contact_person")
    @Lob
    public String getContactPerson() {
        return this.contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    @Column(name="is_public_api")
    @Searchable
    public Boolean getIsPublicApi() {
        return this.isPublicApi;
    }

    public void setIsPublicApi(Boolean isPublicApi) {
        this.isPublicApi = isPublicApi;
    }

    @Column(length=2000, name="description")
    @Searchable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="status")
    @Enumerated
    public PluginStatus getStatus() {
        return this.status;
    }

    public void setStatus(PluginStatus status) {
        this.status = status;
    }

    @Column(name="config_xml")
    @Lob
    public String getConfigXml() {
        return this.configXml;
    }

    public void setConfigXml(String configXml) {
        this.configXml = configXml;
    }

    @Column(name="init_parm_xml")
    @Lob
    public String getInitParmXml() {
        return this.initParmXml;
    }

    public void setInitParmXml(String initParmXml) {
        this.initParmXml = initParmXml;
    }

    @ManyToOne
    @JoinColumn(name="PLUGIN_TYPE_ID", nullable=false)
    @Searchable
    public HFrPluginType getPluginType() {
        return this.pluginType;
    }

    public void setPluginType(HFrPluginType type) {
        this.pluginType = type;
    }

    @Column(name="index_xml")
    @Searchable
    @Lob
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    @Column(length=255, name="contact_last_name")
    @Searchable
    public String getContactLastName() {
        return this.contactLastName;
    }

    public void setContactLastName(String contactLastName) {
        this.contactLastName = contactLastName;
    }

    @Column(length=255, name="contact_first_name")
    @Searchable
    public String getContactFirstName() {
        return this.contactFirstName;
    }

    public void setContactFirstName(String contactFirstName) {
        this.contactFirstName = contactFirstName;
    }

    @Column(length=510, name="contact_name")
    @Searchable
    public String getContactName() {
        if (this.contactName == null) {
            return this.getContactFirstName() + " " + this.getContactLastName();
        }
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = this.getContactFirstName() + " " + this.getContactLastName();
    }

    @Column(length=255, name="jar_file_name")
    public String getJarFileName() {
        return this.jarFileName;
    }

    public void setJarFileName(String jarFileName) {
        this.jarFileName = jarFileName;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="DEPLOYMENT_MODE")
    @Searchable
    public DeploymentMode getDeploymentMode() {
        return this.deploymentMode;
    }

    public void setDeploymentMode(DeploymentMode deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    public static enum DeploymentMode {
        BUNDLED,
        CUSTOM;

    }
}

