/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import java.util.Locale;

public class CodeTablesDescGetter {
    private static final ExLogger log = ExLogger.getExLogger(CodeTablesDescGetter.class);
    private CodeTablesManager ctManager = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
    private String language;

    public CodeTablesDescGetter() {
    }

    public CodeTablesDescGetter(Locale locale) {
        if (locale != null) {
            this.language = locale.toString();
        }
    }

    public String getDescription(String codeTableName, String code) {
        try {
            return this.ctManager.findCodeTableCodeByLanguageAndTableNameAndCode(this.language, codeTableName, code).getDescription();
        }
        catch (Exception e) {
            log.info("Code Table: '" + codeTableName + "', code: '" + code + "' not found");
            return null;
        }
    }

    public String getDescription(String codeTableName, Locale locale, String code) {
        if (locale != null) {
            this.language = locale.toString();
        }
        return this.getDescription(codeTableName, code);
    }
}

