/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api;

import com.exlibris.core.infra.common.cache.SessionUtils;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.codetables.HCodeTables;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class CodeTablesResourceBundle
extends ResourceBundle {
    private static final ExLogger log = ExLogger.getExLogger(CodeTablesResourceBundle.class);
    private static String DEFAULT_RESSOURCE = CodeTablesResourceBundle.class.getName();
    private static String defaultBundle;
    private CodeTablesManager ctManager;
    private String codeTableName;
    public static final String UI_TABLE = "UILabels";
    private static final String USER_LANGUAGE = "UserLanguage";
    public HashMap<String, Map<String, String>> lookup;
    private String language;

    public static ResourceBundle getDefaultBundle(Locale locale) {
        if (locale == null) {
            return ResourceBundle.getBundle(CodeTablesResourceBundle.getDefaultBundle());
        }
        return ResourceBundle.getBundle(CodeTablesResourceBundle.getDefaultBundle(), locale);
    }

    public CodeTablesResourceBundle(String codeTableName) {
        this.codeTableName = codeTableName;
    }

    public CodeTablesResourceBundle() {
        this.codeTableName = UI_TABLE;
    }

    public CodeTablesResourceBundle(String codeTableName, String lang) {
        this.codeTableName = codeTableName;
        this.language = lang;
    }

    private void init() {
        this.language = SessionUtils.getSessionLanguage();
        if (this.ctManager == null && (this.lookup == null || this.lookup.size() == 0)) {
            this.lookup = new HashMap();
            this.ctManager = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
            List<HCodeTables> codeTables = this.ctManager.findAllCodeTableByLanguageAndNameNoCopy("en", USER_LANGUAGE);
            for (HCodeTables codeTable : codeTables) {
                Map map = new HashMap();
                try {
                    map = this.ctManager.getCodeTableFromTreeCache(this.codeTableName, this.language);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.lookup.put(codeTable.getCode(), map);
            }
        }
    }

    @Override
    public Enumeration<String> getKeys() {
        this.init();
        return Collections.enumeration(this.lookup.get("en").keySet());
    }

    @Override
    protected Object handleGetObject(String code) {
        String res;
        if (code == null) {
            code = "";
        }
        if ((res = this.getValue(code)) == null) {
            log.debug((Object)("NULL VALUE FOR LANG/CODE  --- " + this.language + "/" + code), new String[0]);
            res = code;
        } else {
            res = res.trim();
        }
        res = StringEscapeUtils.unescapeHtml((String)res);
        return res;
    }

    public String getString(String key, Object[] parms) {
        this.init();
        String res = this.lookup.get(this.language).get(key);
        if (res != null) {
            for (int i = 0; i < parms.length; ++i) {
                log.debug((Object)("CODE " + key + " --- VALUE ---" + res), new String[0]);
                String oldChar = "{" + i + "}";
                String newChar = (String)parms[i];
                res = res.replace(oldChar, newChar);
            }
        }
        res = StringEscapeUtils.unescapeHtml((String)res);
        return res;
    }

    public static String getDefaultBundle() {
        if (defaultBundle == null) {
            return DEFAULT_RESSOURCE;
        }
        return defaultBundle;
    }

    public static void setDefaultBundle(String defaultBundle) {
        CodeTablesResourceBundle.defaultBundle = defaultBundle;
    }

    private final String getValue(String code) {
        this.language = SessionUtils.getSessionLanguage();
        if (this.ctManager == null) {
            this.ctManager = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        }
        try {
            String owner = "CRS00";
            String value = this.ctManager.getCodeTableValueFromTreeCache(this.codeTableName, this.language, owner, code);
            if (StringUtils.isBlank((String)value) && !"en".equals(this.language)) {
                value = this.ctManager.getCodeTableValueFromTreeCache(this.codeTableName, "en", owner, code);
            }
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

