/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.database.sqlcommand;

import com.exlibris.core.infra.svc.api.database.JDBCUtils;
import com.exlibris.core.infra.svc.api.database.sqlcommand.AbstractSQLCommand;
import com.exlibris.core.infra.svc.api.database.sqlcommand.SQLCommandBean;
import com.exlibris.core.infra.svc.api.database.sqlcommand.SQLCommandResults;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.xml.parsers.ParserConfigurationException;

public class SchemaManagementSQLCommand
extends AbstractSQLCommand {
    @Override
    public SQLCommandResults execute(SQLCommandBean commandBean) throws SQLException {
        String orderBy = commandBean.getParams().getOrderBy();
        String searchTerm = commandBean.getParams().getSearchTerm();
        String whereClause = "where dba_segments.OWNER = dba_users.USERNAME";
        if (searchTerm != null && !searchTerm.equals("")) {
            whereClause = whereClause + " and dba_segments.OWNER like '%" + searchTerm + "%'";
        }
        String query = "select dba_segments.OWNER,round(sum((dba_segments.BYTES)/1024/1024),1) Msize,dba_users.ACCOUNT_STATUS\nfrom dba_segments,dba_users " + whereClause + " group by dba_segments.OWNER,dba_users.ACCOUNT_STATUS";
        if (orderBy != null && !orderBy.equals("")) {
            query = query + " order by dba_segments." + orderBy;
        }
        Statement stmt = commandBean.getConnection().createStatement();
        ResultSet rs = stmt.executeQuery(query);
        SQLCommandResults results = new SQLCommandResults();
        try {
            results.setResults(JDBCUtils.toDocument(rs));
        }
        catch (ParserConfigurationException e) {
            results.setSuccess(false);
            results.setResults(null);
            return results;
        }
        results.setSuccess(true);
        return results;
    }
}

