/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.email;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.xml.XmlUtil;
import java.util.List;
import java.util.Map;

public class EmailData {
    private final List<Object> emailInputFields;
    private static final String EMAIL_DATA_TAG_NAME = "email-data";
    private static final String ADDITIONAL_FIELDS = "additional-fields";
    public static final String GENERAL_INFO = "General-Info";
    final String XML_DECLARATION_PREFIX = "<?xml";
    final String XML_DECLARATION_POSTFIX = "?>";
    final String lineSeparator = System.getProperty("line.separator");
    protected static ExLogger logger = ExLogger.getExLogger(EmailData.class);

    public EmailData() {
        this.emailInputFields = null;
    }

    public EmailData(List<Object> emailInputFields) {
        this.emailInputFields = emailInputFields;
    }

    public String asXml() {
        return this.asXml(false, null);
    }

    public String asXml(String emailInputFieldXml) {
        StringBuffer xmlContent = new StringBuffer("<email-data>");
        xmlContent.append(emailInputFieldXml);
        xmlContent.append(this.lineSeparator).append("</").append(EMAIL_DATA_TAG_NAME).append(">");
        return xmlContent.toString();
    }

    public String asXml(String tagName, boolean withAdditionalFields, Map<String, String> additionalFields) {
        StringBuffer xmlContent = new StringBuffer("<email-data>");
        if (tagName == null) {
            xmlContent.append(this.asXmlContent(ADDITIONAL_FIELDS, additionalFields));
        } else {
            xmlContent.append(this.asXmlContent(tagName, additionalFields));
        }
        xmlContent.append(this.lineSeparator).append("</").append(EMAIL_DATA_TAG_NAME).append(">");
        return xmlContent.toString();
    }

    public String asXml(boolean withAdditionalFields, Map<String, String> additionalFields) {
        return this.asXml(null, withAdditionalFields, additionalFields);
    }

    public String asXmlContent(String tagName, Map<String, String> additionalFields) {
        StringBuffer xmlContent = new StringBuffer();
        if (additionalFields != null) {
            xmlContent.append(this.addEmailAdditionalFields(tagName, additionalFields));
        }
        if (this.emailInputFields != null) {
            String emailInputFieldXml = null;
            for (Object emailInputFieldObj : this.emailInputFields) {
                try {
                    emailInputFieldXml = XmlUtil.getBeanAsXML(emailInputFieldObj, true);
                    if (emailInputFieldXml.trim().startsWith("<?xml")) {
                        int xmlDecPostfixPos = emailInputFieldXml.indexOf("?>");
                        if (xmlDecPostfixPos > 0) {
                            xmlDecPostfixPos += "?>".length();
                        }
                        emailInputFieldXml = emailInputFieldXml.substring(xmlDecPostfixPos).trim();
                    }
                }
                catch (Throwable t) {
                    logger.error(DescriptorConstants.GN_UnexpectedError, (Object)t, null);
                }
                xmlContent.append(this.lineSeparator).append(emailInputFieldXml);
            }
        }
        return xmlContent.toString();
    }

    public String addEmailAdditionalFields(String tagName, Map<String, String> additionalFields) {
        if (additionalFields.isEmpty()) {
            return "";
        }
        StringBuffer xmlContent = new StringBuffer("<" + tagName + ">");
        for (String additionalFieldString : additionalFields.keySet()) {
            xmlContent.append("<" + additionalFieldString + ">");
            xmlContent.append(additionalFields.get(additionalFieldString));
            xmlContent.append("</" + additionalFieldString + ">");
        }
        xmlContent.append("</").append(tagName).append(">");
        return xmlContent.toString();
    }

    public List<Object> getEmailInputFields() {
        return this.emailInputFields;
    }
}

