/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.locator;

import com.exlibris.core.infra.common.annotations.ServiceContext;
import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.mx.util.MBeanServerLocator;

public class ServiceLocator {
    private static ExLogger log = ExLogger.getExLogger(ServiceLocator.class);
    private InitialContext defInitalContext;
    private Map<String, InitialContext> contextCache;
    private static Hashtable<?, ?> initialEnvironment = null;
    private Map proxyCache;
    private static ServiceLocator ourInstance = new ServiceLocator();
    private static MBeanServer currentServer;
    private String currentHostAddress;
    private String localHostAddress = "localhost";
    private boolean modeSA = false;
    private static final String RESOURCE_BUNDLE = "topology.properties";

    public static ServiceLocator getInstance() {
        return ourInstance;
    }

    private ServiceLocator() {
        this.init();
    }

    public void reset() {
        this.init();
    }

    private void init() {
        try {
            this.defInitalContext = new InitialContext(initialEnvironment);
            this.contextCache = new HashMap<String, InitialContext>();
            this.proxyCache = new HashMap();
            this.initCurrentServerConf();
            this.initServiceContextCache();
        }
        catch (NamingException ex) {
            System.err.printf("Error in CTX looking up %s because of %s while %s", ex.getRemainingName(), ex.getCause(), ex.getExplanation());
        }
    }

    public <T> T lookUp(Class T) {
        return this.lookUp(T, null);
    }

    public <T> T lookUp(Class T, String appId) {
        String proxyKey = this.getContextKey(T.getSimpleName(), appId);
        Object ret = this.proxyCache.get(proxyKey);
        if (ret != null) {
            return (T)ret;
        }
        InitialContext initialContext = this.getInitialContext(T, appId);
        try {
            boolean remote = true;
            String provUrl = (String)initialContext.getEnvironment().get("java.naming.provider.url");
            if (provUrl.equalsIgnoreCase(this.currentHostAddress) || provUrl.equalsIgnoreCase(this.localHostAddress)) {
                remote = false;
            }
            String bindSuff = "/local";
            if (remote || this.modeSA) {
                bindSuff = "/remote";
            }
            if (ret == null) {
                ret = initialContext.lookup(T.getSimpleName() + bindSuff);
                this.proxyCache.put(proxyKey, ret);
            }
            return (T)ret;
        }
        catch (NamingException e) {
            log.error(DescriptorConstants.GN_UnableToInitEJB, (Object)e, null);
            return null;
        }
    }

    private void initCurrentServerConf() {
        try {
            currentServer = MBeanServerLocator.locateJBoss();
            this.currentHostAddress = (String)currentServer.getAttribute(new ObjectName("jboss.system:type=ServerInfo"), "HostAddress");
            String rmiPort = currentServer.getAttribute(new ObjectName("jboss:service=Naming"), "Port").toString();
            this.currentHostAddress = this.currentHostAddress + ":" + rmiPort;
            this.localHostAddress = this.localHostAddress + ":" + rmiPort;
        }
        catch (Exception ex) {
            this.currentHostAddress = this.localHostAddress = this.localHostAddress + ":2801";
            this.modeSA = true;
        }
    }

    private InitialContext getInitialContext(Class T, String appId) {
        InitialContext initialContext = null;
        String scName = "";
        ServiceContext sc = T.getPackage().getAnnotation(ServiceContext.class);
        if (sc != null) {
            scName = sc.name();
            String contextKey = this.getContextKey(scName, appId);
            initialContext = this.contextCache.get(contextKey);
            if (initialContext == null) {
                log.debug((Object)("InitialContext not found for service context - " + sc + ", application id - " + appId), new String[0]);
            }
            if (initialContext == null && appId == null) {
                initialContext = this.defInitalContext;
            }
        } else {
            initialContext = this.defInitalContext;
        }
        return initialContext;
    }

    private String getContextKey(String scName, String appId) {
        String key = scName;
        if (appId != null && appId.length() > 0) {
            key = key + "_" + appId;
        }
        return key;
    }

    private void initServiceContextCache() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        PropertyResourceBundle resourceBundle = null;
        try {
            resourceBundle = new PropertyResourceBundle(loader.getResourceAsStream(RESOURCE_BUNDLE));
        }
        catch (IOException e) {
            log.error("Error reading topology configuration file - " + e.getMessage(), new String[0]);
        }
        if (resourceBundle != null) {
            Enumeration<String> keys = resourceBundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = (String)resourceBundle.getObject(key);
                this.putContextInCache(value, key, null);
            }
        } else {
            this.putContextInCache(this.currentHostAddress, "infra", null);
            this.putContextInCache(this.currentHostAddress, "repository", null);
            this.putContextInCache(this.currentHostAddress, "deposit", null);
            this.putContextInCache(this.currentHostAddress, "backoffice", null);
        }
    }

    private void putContextInCache(String providerUrl, String contextName, String appId) {
        try {
            Properties properties = new Properties();
            properties.put("java.naming.provider.url", providerUrl);
            InitialContext initialContext = new InitialContext(properties);
            this.contextCache.put(this.getContextKey(contextName, appId), initialContext);
        }
        catch (NamingException ex) {
            System.err.printf("Fatal Error in service context - %s, application id - %s, in CTX looking up %s because of %s while %s", contextName, appId, ex.getRemainingName(), ex.getCause(), ex.getExplanation());
        }
    }

    public String getCurrentHostAddress() {
        return this.currentHostAddress;
    }

    public boolean isLocalHostAddress(String url) {
        return url.equalsIgnoreCase(this.currentHostAddress) || url.equalsIgnoreCase(this.localHostAddress);
    }

    public static void setInitialEnvironment(Hashtable<?, ?> initialEnvironment) {
    }
}

