/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.plugins;

import com.exlibris.core.infra.common.exceptions.InfraException;
import com.exlibris.core.infra.common.javaclass.JavaClassUtils;
import com.exlibris.core.infra.common.javaclass.PluginClassLoader;
import com.exlibris.core.infra.model.plugins.HFrPluginInstance;
import com.exlibris.core.infra.model.plugins.HFrPluginType;
import com.exlibris.core.infra.model.plugins.NewPlugins;
import com.exlibris.core.infra.model.plugins.PluginMetadata;
import com.exlibris.core.infra.model.plugins.PluginStatus;
import com.exlibris.core.infra.svc.api.PluginManager;
import com.exlibris.core.infra.svc.api.plugins.PluginListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PluginsInitializatorUtils {
    private static final Logger log = Logger.getLogger(PluginsInitializatorUtils.class);
    public static Map<String, PluginClassLoader> pluginClassLoaders = new HashMap<String, PluginClassLoader>();

    public static List<String> load(PluginManager pluginManager, HFrPluginInstance.DeploymentMode deploymentMode) {
        log.info((Object)("Deploying Rosetta Plugins (" + (Object)((Object)deploymentMode) + "):"));
        ArrayList<String> errors = new ArrayList<String>();
        int deployedCount = 0;
        int alreadyDeployedCount = 0;
        int redeployedCount = 0;
        int failedCount = 0;
        int movedToDeploy = 0;
        try {
            NewPlugins plugins = pluginManager.getAllNewPlugins(deploymentMode);
            List<PluginMetadata> newPlugins = plugins.getMetadataList();
            for (PluginMetadata pluginMetadata : newPlugins) {
                DeploymentResult result = PluginsInitializatorUtils.deployIfNeeded(pluginManager, pluginMetadata, deploymentMode);
                if (DeploymentResult.NEW_DEPLOY == result) {
                    ++deployedCount;
                } else if (DeploymentResult.UPDATED == result) {
                    ++redeployedCount;
                } else if (DeploymentResult.MOVED_TO_DEPLOY == result) {
                    ++movedToDeploy;
                } else if (DeploymentResult.FAILED == result) {
                    ++failedCount;
                    errors.add("Failed to deploy " + pluginMetadata.getPluginName());
                } else if (DeploymentResult.ALREADY_DEPLOYED == result) {
                    ++alreadyDeployedCount;
                }
                if (result != DeploymentResult.UPDATED && result != DeploymentResult.ALREADY_DEPLOYED) continue;
                PluginsInitializatorUtils.updateInstancesVersion(pluginManager, pluginMetadata);
            }
            log.info((Object)"Rebuilding missing index xmls...");
            pluginManager.rebuildIndexXmls();
            log.info((Object)("Plugin Deployed:" + deployedCount + ", Already Deployed:" + alreadyDeployedCount + ", Plugin Updated:" + redeployedCount + ", Moved to Deploy:" + movedToDeploy + ", Failed to Deploy:" + failedCount));
        }
        catch (Exception e) {
            String err = "failed to initialize OTB plugins ";
            log.error((Object)err, (Throwable)e);
            errors.add(err + e.getMessage());
        }
        return errors;
    }

    private static DeploymentResult deployIfNeeded(PluginManager pluginManager, PluginMetadata pluginMetadata, HFrPluginInstance.DeploymentMode deploymentMode) {
        HFrPluginInstance instance = null;
        String pluginName = pluginMetadata.getPluginName();
        HFrPluginType type = pluginManager.getPluginTypeByName(pluginMetadata.getPluginTypeName());
        boolean deployed = pluginManager.isOTBPluginDeployed(pluginName);
        boolean redeploy = false;
        try {
            if (deployed) {
                redeploy = pluginManager.isNewVersion(pluginName, pluginMetadata.getPluginVersion());
                if (redeploy) {
                    PluginsInitializatorUtils.log(pluginName, pluginMetadata.getJarFileName(), pluginMetadata.getPluginVersion(), DeploymentResult.UPDATED);
                    instance = PluginsInitializatorUtils.deploy(pluginManager, deploymentMode, pluginMetadata, type, true);
                    PluginsInitializatorUtils.runListener(instance, type);
                    return DeploymentResult.UPDATED;
                }
                if (!pluginManager.isInDeployDir(deploymentMode, pluginMetadata)) {
                    PluginsInitializatorUtils.log(pluginName, pluginMetadata.getJarFileName(), pluginMetadata.getPluginVersion(), DeploymentResult.MOVED_TO_DEPLOY);
                    pluginManager.moveToDeployDir(deploymentMode, pluginMetadata, pluginMetadata.getJarFileName(), pluginMetadata.getJarFilePath());
                    return DeploymentResult.MOVED_TO_DEPLOY;
                }
                PluginsInitializatorUtils.log(pluginName, pluginMetadata.getJarFileName(), pluginMetadata.getPluginVersion(), DeploymentResult.ALREADY_DEPLOYED);
                return DeploymentResult.ALREADY_DEPLOYED;
            }
            PluginsInitializatorUtils.log(pluginName, pluginMetadata.getJarFileName(), pluginMetadata.getPluginVersion(), DeploymentResult.NEW_DEPLOY);
            instance = PluginsInitializatorUtils.deploy(pluginManager, deploymentMode, pluginMetadata, type, false);
            PluginsInitializatorUtils.runListener(instance, type);
            return DeploymentResult.NEW_DEPLOY;
        }
        catch (Exception e) {
            PluginsInitializatorUtils.log(pluginName, pluginMetadata.getJarFileName(), pluginMetadata.getPluginVersion(), DeploymentResult.FAILED);
            return DeploymentResult.FAILED;
        }
    }

    private static void log(String pluginName, String jarName, double version, DeploymentResult operation) {
        StringBuilder logMsg = new StringBuilder();
        logMsg.append("|");
        PluginsInitializatorUtils.logColumn(logMsg, pluginName, 35);
        logMsg.append(" | ");
        PluginsInitializatorUtils.logColumn(logMsg, jarName, 30);
        logMsg.append(" | ");
        PluginsInitializatorUtils.logColumn(logMsg, version + "", 5);
        logMsg.append(" | ");
        PluginsInitializatorUtils.logColumn(logMsg, operation.name(), 35);
        logMsg.append("|");
        log.info((Object)logMsg.toString());
    }

    private static void logColumn(StringBuilder logMsg, String columnValue, int columnWidth) {
        if (columnWidth - columnValue.length() > 0) {
            logMsg.append(columnValue);
        } else {
            logMsg.append(columnValue.substring(0, columnWidth - 3)).append("...");
        }
        for (int i = 0; i < columnWidth - columnValue.length(); ++i) {
            logMsg.append(" ");
        }
    }

    private static HFrPluginInstance deploy(PluginManager pluginManager, HFrPluginInstance.DeploymentMode deploymentMode, PluginMetadata pluginMetadata, HFrPluginType type, boolean redeploy) throws InfraException {
        HFrPluginInstance instance = pluginManager.addPlugin(deploymentMode, pluginMetadata, type.getCreator(), type.getOwner(), redeploy, true);
        instance.setStatus(PluginStatus.ACTIVE);
        pluginManager.updatePlugin(instance);
        return instance;
    }

    private static void updateInstancesVersion(PluginManager pluginManager, PluginMetadata pluginMetadata) {
        try {
            List<HFrPluginInstance> jarInstances = pluginManager.getPluginsByPluginJar(pluginMetadata.getJarFileName());
            boolean updated = false;
            for (HFrPluginInstance jarIns : jarInstances) {
                if (!(jarIns.getPluginVersion() < pluginMetadata.getPluginVersion())) continue;
                jarIns.setPluginVersion(pluginMetadata.getPluginVersion());
                pluginManager.updatePlugin(jarIns);
                updated = true;
            }
            if (updated) {
                PluginsInitializatorUtils.log(pluginMetadata.getPluginName(), pluginMetadata.getJarFileName(), pluginMetadata.getPluginVersion(), DeploymentResult.UPDATED_VERSION_FOR_OLD_INSTANCES);
            }
        }
        catch (Exception e) {
            log.error((Object)"failed to update old pluginInstance's version", (Throwable)e);
        }
    }

    private static void runListener(HFrPluginInstance instance, HFrPluginType type) throws InfraException {
        boolean successfulyRunListener;
        if (type.getPluginListener() != null && !(successfulyRunListener = PluginsInitializatorUtils.runPluginListener(instance))) {
            log.error((Object)("failed to run plugin listener: " + type.getPluginListener()));
        }
    }

    public static void loadJarToClassPath(String jarFilePath, String jarFileName) {
        File jar = new File(jarFilePath + jarFileName);
        try {
            JavaClassUtils.addURLToClassLoader(jar.toURI().toURL());
        }
        catch (Exception e) {
            log.error((Object)("failed to load jar/jar class into loader class path " + jarFileName), (Throwable)e);
        }
    }

    public static URLClassLoader getPluginClassLoader(String jarFilePath, String jarFileName, double version) {
        PluginClassLoader classLoader = null;
        File jar = new File(jarFilePath + jarFileName);
        if (jar == null) {
            return classLoader;
        }
        ClassLoader sysloader = Thread.currentThread().getContextClassLoader();
        classLoader = pluginClassLoaders.get(PluginsInitializatorUtils.generateClassLoaderMapKey(jarFilePath, jarFileName, version));
        if (classLoader == null) {
            try {
                classLoader = new PluginClassLoader(new URL[]{jar.toURI().toURL()}, sysloader);
                classLoader.addJar(jar, version);
                pluginClassLoaders.put(PluginsInitializatorUtils.generateClassLoaderMapKey(jarFilePath, jarFileName, version), classLoader);
            }
            catch (MalformedURLException e) {
                log.error((Object)("failed to load jar/jar class into loader class path " + jarFileName), (Throwable)e);
            }
        }
        return classLoader;
    }

    private static String generateClassLoaderMapKey(String jarFilePath, String jarFileName, double version) {
        return jarFilePath + jarFileName + "_" + version;
    }

    public static boolean runPluginListener(HFrPluginInstance pm) {
        PluginListener pl = null;
        try {
            pl = (PluginListener)Class.forName(pm.getPluginType().getPluginListener()).newInstance();
        }
        catch (Exception e) {
            log.warn((Object)("PluginListener not found for plugin type: " + pm.getPluginType().getPluginTypeName()));
        }
        try {
            boolean postInstallOk;
            if (pl != null && !(postInstallOk = pl.postInsall(pm))) {
                String errorMsg = "Post install for plugin type: " + pm.getPluginType().getPluginTypeName() + " failed.";
                log.error((Object)errorMsg);
                return false;
            }
        }
        catch (Exception e) {
            String errorMsg = "Post install for plugin type: " + pm.getPluginType().getPluginTypeName() + " throw an exception: " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            return false;
        }
        return true;
    }

    public static enum DeploymentResult {
        ALREADY_DEPLOYED,
        NEW_DEPLOY,
        MOVED_TO_DEPLOY,
        FAILED,
        UPDATED,
        UPDATED_VERSION_FOR_OLD_INSTANCES;

    }
}

