/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.quartz;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.logs.LogTable;
import com.exlibris.core.infra.model.quartz.QuartzJobConfig;
import com.exlibris.core.infra.svc.api.common.DBLogger;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.quartz.InfraQuartzJobsService;
import java.util.Calendar;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public abstract class InfraStatefulJob
implements StatefulJob {
    public static final String QUARTZ_DB_LOGGER_GROUP = "quartz_jobs_logs";
    private ExLogger exLogger = ExLogger.getExLogger(this.getClass(), "JB");
    private DBLogger dbLogger = null;
    private boolean useDbLogger = false;

    public abstract void executeInternal(JobExecutionContext var1) throws JobExecutionException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void execute(JobExecutionContext context) throws JobExecutionException {
        Calendar startTime = Calendar.getInstance();
        Long quartzJobConfigId = null;
        if (context != null) {
            quartzJobConfigId = (Long)context.getJobDetail().getJobDataMap().get((Object)"job_id");
        }
        if (quartzJobConfigId == null) {
            this.exLogger.info("Notice: This job is not scheduled from the " + InfraQuartzJobsService.class.getSimpleName() + ", and therefore not associated to " + QuartzJobConfig.class.getSimpleName() + " entity.");
        } else {
            this.dbLogger = new DBLogger(QUARTZ_DB_LOGGER_GROUP, String.valueOf(quartzJobConfigId), startTime);
        }
        try {
            this.executeInternal(context);
            if (quartzJobConfigId == null) return;
        }
        catch (JobExecutionException e) {
            try {
                this.exLogger.error("Error occurred while execute job." + (StringUtils.isNotBlank((String)e.getMessage()) ? "\n  Error: " + e.getMessage() : ""), new String[0]);
                throw e;
            }
            catch (Throwable throwable) {
                if (quartzJobConfigId == null) throw throwable;
                try {
                    InfraQuartzJobsService infraQuartzJobsService = (InfraQuartzJobsService)ServiceLocator.getInstance().lookUp(InfraQuartzJobsService.class);
                    infraQuartzJobsService.updateJobLastRunDate(quartzJobConfigId, startTime.getTime());
                    if (!this.useDbLogger) throw throwable;
                    LogTable.LogStatus logStatus = this.dbLogger.getLogStatus();
                    String msg = "Job completed " + (logStatus == LogTable.LogStatus.SUCCESS ? "Successfully" : (logStatus == LogTable.LogStatus.WARN ? "with Warnings" : (logStatus == LogTable.LogStatus.ERROR ? "with Errors" : logStatus.name())));
                    this.dbLogger.info(msg);
                    this.dbLogger.save();
                    throw throwable;
                }
                catch (EntityNotFoundException e2) {
                    this.exLogger.error("The quartzJobConfig ID - " + quartzJobConfigId + " from the JobDataMap - does not exist in DB.", new String[0]);
                }
                throw throwable;
            }
        }
        try {
            InfraQuartzJobsService infraQuartzJobsService = (InfraQuartzJobsService)ServiceLocator.getInstance().lookUp(InfraQuartzJobsService.class);
            infraQuartzJobsService.updateJobLastRunDate(quartzJobConfigId, startTime.getTime());
            if (!this.useDbLogger) return;
            LogTable.LogStatus logStatus = this.dbLogger.getLogStatus();
            String msg = "Job completed " + (logStatus == LogTable.LogStatus.SUCCESS ? "Successfully" : (logStatus == LogTable.LogStatus.WARN ? "with Warnings" : (logStatus == LogTable.LogStatus.ERROR ? "with Errors" : logStatus.name())));
            this.dbLogger.info(msg);
            this.dbLogger.save();
            return;
        }
        catch (EntityNotFoundException e) {
            this.exLogger.error("The quartzJobConfig ID - " + quartzJobConfigId + " from the JobDataMap - does not exist in DB.", new String[0]);
            return;
        }
    }

    protected void setDbLoggerOn() {
        if (this.dbLogger == null) {
            this.exLogger.error("Try to set DbLoggerOn for job but dbLogger is null.", new String[0]);
        } else {
            this.useDbLogger = true;
        }
    }

    protected void setDbLoggerOff() {
        this.useDbLogger = false;
    }

    protected void writeLogInfo(String message) {
        this.exLogger.info(message);
        if (this.useDbLogger) {
            this.dbLogger.info(message);
        }
    }

    protected void writeLogWarning(String message) {
        this.exLogger.warn((Object)message, new String[0]);
        if (this.useDbLogger) {
            this.dbLogger.warn(message);
        }
    }

    protected void writeLogError(String message) {
        this.exLogger.error(message, new String[0]);
        if (this.useDbLogger) {
            this.dbLogger.error(message);
        }
    }

    protected void writeLogError(String message, Throwable e) {
        this.exLogger.error(message, e, new String[0]);
        if (this.useDbLogger) {
            this.dbLogger.error(message);
        }
    }

    protected void writeLogDebug(String message) {
        this.exLogger.debug((Object)message, new String[0]);
    }
}

