/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.tools;

import com.exlibris.core.infra.common.exceptions.InfraException;
import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.shared.dataObjects.KeyValuePair;
import com.exlibris.core.infra.common.util.ReflectionUtil;
import com.exlibris.core.infra.model.DividedDate;
import com.exlibris.core.infra.model.codetables.HCodeTables;
import com.exlibris.core.infra.model.codetables.HMappingTables;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.CodeTablesResourceBundle;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.utils.JSTreeUtil;
import com.exlibris.core.infra.svc.api.utils.TreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import org.json.JSONObject;

public class WhereClauser {
    public static final String XTYPE_UI_LABEL_PREFIX = "ui.xType.";
    public static final String DATE_SEARCH_TYPE = "Date";
    public static final String NATIVE_DATE_SEARCH_TYPE = "Native_Date";
    public static final String FREE_TEXT_SEARCH_TYPE = "Free Text";
    public static final String NATIVE_FREE_TEXT_SEARCH_TYPE = "Native_Free Text";
    public static final String NUMERIC_SEARCH_TYPE = "Numeric";
    public static final String NATIVE_NUMERIC_SEARCH_TYPE = "Native_Numeric";
    public static final String LOOKUP_SEARCH_TYPE = "Lookup";
    public static final String NATIVE_LOOKUP_SEARCH_TYPE = "Native_Lookup";
    public static final String MAPPING_LOOKUP_SEARCH_TYPE = "MappingLookup";
    public static final String NATIVE_MAPPING_LOOKUP_SEARCH_TYPE = "Native_MappingLookup";
    public static final String PICKUP_SEARCH_TYPE = "Pickup";
    public static final String NATIVE_PICKUP_SEARCH_TYPE = "Native_Pickup";
    private static final ExLogger logger = ExLogger.getExLogger(WhereClauser.class);
    private static ResourceBundle resourceBundle = CodeTablesResourceBundle.getDefaultBundle(null);
    int id;
    String from;
    LogicalOperator logicalOperator;
    String fieldName;
    String uiLabelPrefix;
    XType compareType;
    String compareValue;
    String uiCompareValue;
    String strLogicalOperator;
    String strCompareType;
    List<KeyValuePair<String, String>> compareTypeOptions;
    List<String> compareTypeKeys;
    String inputDateTagFormat;
    DividedDate dividedDate = null;
    List<HCodeTables> codeTableList = null;
    String searchType = "Free Text";
    String pickupUrl;
    Collection<? extends TreeNode> treeList;
    List<JSONObject> compareValueList;
    String normalizingProfile = "search";
    boolean editable = true;
    int indentation = 1;
    public static final List<String> freeTextCompareTypeOptions = new ArrayList<String>();
    public static final List<String> nativeFreeTextCompareTypeOptions = new ArrayList<String>();
    public static final List<String> dateCompareTypeOptions = new ArrayList<String>();
    public static final List<String> nativeDateCompareTypeOptions = new ArrayList<String>();
    public static final List<String> lookupCompareTypeOptions = new ArrayList<String>();
    public static final List<String> nativeLookupCompareTypeOptions = new ArrayList<String>();
    public static final List<String> numericCompareTypeOptions = new ArrayList<String>();
    public static final List<String> nativeNumericCompareTypeOptions = new ArrayList<String>();
    public static final List<String> treeCompareTypeOptions = new ArrayList<String>();

    public WhereClauser() {
    }

    public WhereClauser(LogicalOperator logicalOperator, String fieldName, XType compareType, String compareValue) {
        this.logicalOperator = logicalOperator;
        this.fieldName = fieldName;
        this.compareType = compareType;
        this.compareValue = compareValue;
    }

    public WhereClauser createWhereClauser(String form, LogicalOperator logicalOperator, String fieldName, XType compareType, String compareValue) {
        this.from = form;
        this.logicalOperator = logicalOperator;
        this.fieldName = fieldName;
        this.compareType = compareType;
        this.compareValue = compareValue;
        return this;
    }

    public void updateCompareValue() {
        if (this.searchType.equals(DATE_SEARCH_TYPE)) {
            this.compareValue = this.dividedDate.getFullDate();
        }
    }

    public String getForm() {
        return this.from;
    }

    public void setForm(String from) {
        this.from = from;
    }

    public LogicalOperator getLogicalOperator() {
        return this.logicalOperator;
    }

    public void setLogicalOperator(LogicalOperator logicalOperator) {
        this.logicalOperator = logicalOperator;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldUIName() {
        return WhereClauser.getLabel(this.uiLabelPrefix, this.fieldName);
    }

    public void setFieldUIName(String fieldUIName) {
    }

    public void setUiLabelPrefix(String uiLabelPrefix) {
        this.uiLabelPrefix = uiLabelPrefix;
    }

    public XType getCompareType() {
        return this.compareType;
    }

    public void setCompareType(XType compareType) {
        this.compareType = compareType;
    }

    public String getCompareValue() {
        this.updateCompareValue();
        return this.compareValue;
    }

    public void setCompareValue(String compareValue) {
        this.compareValue = compareValue;
    }

    public String getUiCompareValue() {
        return this.uiCompareValue;
    }

    public void setUiCompareValue(String uiCompareValue) {
        this.uiCompareValue = uiCompareValue;
    }

    public String getStrLogicalOperator() {
        if (this.logicalOperator == null) {
            return "";
        }
        return this.logicalOperator.toString();
    }

    public void setStrLogicalOperator(String strLogicalOperator) {
        this.logicalOperator = LogicalOperator.valueOf(strLogicalOperator);
        this.strLogicalOperator = strLogicalOperator;
    }

    public String getStrCompareType() {
        if (this.compareType == null) {
            return "";
        }
        return this.compareType.toString();
    }

    public void setStrCompareType(String strCompareType) {
        this.compareType = XType.valueOf(strCompareType);
        this.strCompareType = strCompareType;
    }

    public List<KeyValuePair<String, String>> getCompareTypeOptions() {
        this.compareTypeOptions = new ArrayList<KeyValuePair<String, String>>();
        try {
            if (this.compareTypeKeys != null) {
                for (String option : this.compareTypeKeys) {
                    String label = resourceBundle.getString(XTYPE_UI_LABEL_PREFIX + option);
                    KeyValuePair<String, String> pair = new KeyValuePair<String, String>(label, option);
                    this.compareTypeOptions.add(pair);
                }
            }
            return this.compareTypeOptions;
        }
        catch (Exception e) {
            System.out.print("problem in ajax div");
            this.compareTypeOptions.add(new KeyValuePair<String, String>("here", "here"));
            return this.compareTypeOptions;
        }
    }

    public void setCompareTypeOptions(List<KeyValuePair<String, String>> compareTypeOptions) {
        this.compareTypeOptions = compareTypeOptions;
    }

    public List<String> getCompareTypeKeys() {
        return this.compareTypeKeys;
    }

    public void setCompareTypeKeys(List<String> compareTypeKeys) {
        this.compareTypeKeys = compareTypeKeys;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public DividedDate getDividedDate() {
        return this.dividedDate;
    }

    public void setDividedDate(DividedDate dividedDate) {
        this.compareValue = dividedDate.getFullDate();
        this.inputDateTagFormat = dividedDate.getInputDateTagFormat();
        this.dividedDate = dividedDate;
    }

    public String getInputDateTagFormat() {
        this.inputDateTagFormat = this.dividedDate.getInputDateTagFormat();
        return this.inputDateTagFormat;
    }

    public void setInputDateTagFormat(String inputDateTagFormat) {
        this.inputDateTagFormat = inputDateTagFormat;
    }

    public List<HCodeTables> getCodeTableList() {
        return this.codeTableList;
    }

    public void setCodeTableList(List<HCodeTables> codeTableList) {
        this.codeTableList = codeTableList;
    }

    public String getSearchType() {
        return this.searchType;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public String getPickupUrl() {
        return this.pickupUrl;
    }

    public void setPickupUrl(String pickupUrl) {
        this.pickupUrl = pickupUrl;
    }

    public String getNormalizingProfile() {
        return this.normalizingProfile;
    }

    public void setNormalizingProfile(String normalizingProfile) {
        this.normalizingProfile = normalizingProfile;
    }

    public void setStrDividedDate(String compareValue) {
        this.dividedDate = new DividedDate(compareValue);
        this.inputDateTagFormat = this.dividedDate.getInputDateTagFormat();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int indentation) {
        this.indentation = indentation;
    }

    public Collection<? extends TreeNode> getTreeList() {
        return this.treeList;
    }

    public void setTreeList(Collection<? extends TreeNode> treeList) {
        this.treeList = treeList;
    }

    public List<JSONObject> getCompareValueList() {
        return this.compareValueList;
    }

    public void setCompareValueList(List<JSONObject> compareValueList) {
        this.compareValueList = compareValueList;
    }

    public String getTree() {
        ArrayList<String> selectedItems = null;
        if (this.compareValue != null) {
            selectedItems = new ArrayList<String>();
            String[] selectedItemsStr = this.compareValue.split(",");
            for (int i = 0; i < selectedItemsStr.length; ++i) {
                selectedItems.add(selectedItemsStr[i]);
            }
        }
        if (this.treeList != null && this.treeList.size() > 0) {
            return JSTreeUtil.getXMLFromTreeNodeList(this.treeList, selectedItems);
        }
        return "";
    }

    public boolean isEmptyTree() {
        return this.treeList == null || this.treeList.size() <= 0;
    }

    public void setCodeTableList(String lookup, String locale) {
        List<HCodeTables> codeTableList = new ArrayList<HCodeTables>();
        if (lookup != null) {
            codeTableList = this.getCodeTableList(lookup, locale);
        }
        this.setCodeTableList(codeTableList);
    }

    public void setCodeTableList(String lookup, String valueColumn, String descriptionColumn) throws InfraException {
        ArrayList<HCodeTables> codeTableList = new ArrayList<HCodeTables>();
        if (lookup != null) {
            List<HMappingTables> mappingTableRows = null;
            CodeTablesManager codeTableManager = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
            if (codeTableManager == null) {
                throw new InfraException(DescriptorConstants.DP_LookUPFailed, "CodeTablesManager");
            }
            mappingTableRows = codeTableManager.findMappingTableByName(lookup);
            for (HMappingTables mappingTableRow : mappingTableRows) {
                try {
                    String value = ReflectionUtil.property2value((Object)mappingTableRow, valueColumn);
                    String description = ReflectionUtil.property2value((Object)mappingTableRow, descriptionColumn);
                    HCodeTables codeTableRow = new HCodeTables();
                    codeTableRow.setCode(value);
                    codeTableRow.setDescription(description);
                    codeTableList.add(codeTableRow);
                }
                catch (Exception e) {
                    logger.error("", e, new String[0]);
                }
            }
        }
        this.setCodeTableList(codeTableList);
    }

    protected List<HCodeTables> getCodeTableList(String tableName, String locale) {
        List<HCodeTables> codeTables = null;
        try {
            CodeTablesManager codeTableManager = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
            codeTables = codeTableManager.findCodeTableByLanguageAndName(locale, tableName, true, "description", "CRS00");
        }
        catch (Exception e) {
            e.getMessage();
        }
        return codeTables;
    }

    public static String getLabel(String prefix, String uiCode) {
        String key = prefix != null ? prefix + uiCode : uiCode;
        String bundeledLabel = resourceBundle.getString(key);
        return bundeledLabel.equals(key) ? uiCode : bundeledLabel;
    }

    static {
        freeTextCompareTypeOptions.add(XType.CONTAIN.toString());
        freeTextCompareTypeOptions.add(XType.EQUAL.toString());
        freeTextCompareTypeOptions.add(XType.START_WITH.toString());
        dateCompareTypeOptions.add(XType.EQUAL.toString());
        dateCompareTypeOptions.add(XType.BEFORE.toString());
        dateCompareTypeOptions.add(XType.AFTER.toString());
        nativeDateCompareTypeOptions.add(XType.OUTER_EQUAL.toString());
        nativeDateCompareTypeOptions.add(XType.BEFORE.toString());
        nativeDateCompareTypeOptions.add(XType.AFTER.toString());
        lookupCompareTypeOptions.add(XType.EQUAL.toString());
        nativeLookupCompareTypeOptions.add(XType.OUTER_EQUAL.toString());
        nativeLookupCompareTypeOptions.add(XType.NOT_EQUAL.toString());
        nativeLookupCompareTypeOptions.add(XType.IS_EMPTY.toString());
        nativeLookupCompareTypeOptions.add(XType.IS_NOT_EMPTY.toString());
        numericCompareTypeOptions.add(XType.EQUAL.toString());
        numericCompareTypeOptions.add(XType.GREATER_THAN.toString());
        numericCompareTypeOptions.add(XType.GREATER_EQUAL.toString());
        numericCompareTypeOptions.add(XType.LESS_THAN.toString());
        numericCompareTypeOptions.add(XType.LESS_EQUAL.toString());
        nativeNumericCompareTypeOptions.add(XType.OUTER_EQUAL.toString());
        nativeNumericCompareTypeOptions.add(XType.GREATER_THAN.toString());
        nativeNumericCompareTypeOptions.add(XType.GREATER_EQUAL.toString());
        nativeNumericCompareTypeOptions.add(XType.LESS_THAN.toString());
        nativeNumericCompareTypeOptions.add(XType.LESS_EQUAL.toString());
        nativeNumericCompareTypeOptions.add(XType.NOT_EQUAL.toString());
        nativeFreeTextCompareTypeOptions.add(XType.OUTER_EQUAL.toString());
        nativeFreeTextCompareTypeOptions.add(XType.LIKE.toString());
        treeCompareTypeOptions.add(XType.IN.toString());
        treeCompareTypeOptions.add(XType.NOT_IN.toString());
    }

    public static enum XType {
        EQUAL,
        START_WITH,
        END_WITH,
        CONTAIN,
        PATTERN,
        BEFORE,
        AFTER,
        OUTER_EQUAL,
        GREATER_THAN,
        GREATER_EQUAL,
        LESS_THAN,
        LESS_EQUAL,
        LIKE,
        NOT_EQUAL,
        IN,
        NOT_IN,
        IS_EMPTY,
        IS_NOT_EMPTY;

    }

    public static enum LogicalOperator {
        AND,
        OR,
        NOT,
        ALL,
        ANY;

    }
}

