/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.utils;

import com.exlibris.core.infra.svc.api.utils.TreeNode;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;

public class JSTreeUtil {
    public static final String NODE_PREFIX = "node_";

    public static String getXMLFromTreeNodeList(Collection<? extends TreeNode> tree, List<String> selectedIDs) {
        StringBuilder sb = new StringBuilder("<root>");
        if (tree != null) {
            for (TreeNode treeNode : tree) {
                sb.append(String.format("<item id='node_%s'", treeNode.getId()));
                if (selectedIDs != null && selectedIDs.contains(String.valueOf(treeNode.getId()))) {
                    sb.append(" selected='true'");
                }
                if (treeNode.getParentId() != null) {
                    sb.append(String.format(" parent_id='node_%s'", treeNode.getParentId()));
                }
                sb.append(String.format("><content><name>%s</name><description>%s</description></content></item>", StringEscapeUtils.escapeXml((String)treeNode.getName()), StringEscapeUtils.escapeXml((String)treeNode.getDescription())));
            }
        }
        return sb.append("</root>").toString().replace("\n", "");
    }

    public static Long getNodeId(String treeNodeId) {
        Long result = null;
        if (treeNodeId != null && treeNodeId.trim().length() > 0) {
            String withoutPrefox = treeNodeId.replaceFirst(NODE_PREFIX, "");
            result = Long.parseLong(withoutPrefox);
        }
        return result;
    }

    public static String getTreeNodeId(Long nodeId) {
        if (nodeId == null) {
            return null;
        }
        return NODE_PREFIX + nodeId;
    }
}

