/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.utils;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.security.UserPrincipal;
import com.exlibris.core.infra.model.HFrUser;
import com.exlibris.core.infra.svc.api.pds.PdsConnector;
import com.exlibris.core.infra.svc.api.pds.PdsUserInfo;
import javax.ejb.SessionContext;
import org.apache.commons.lang.StringUtils;

public class SessionContextUtil {
    private static ExLogger log = ExLogger.getExLogger(SessionContextUtil.class);

    public static UserPrincipal getUserPrincipalFromSession(SessionContext sctx) {
        try {
            if (sctx == null) {
                throw new Exception("sctx is null");
            }
            if (sctx.getCallerPrincipal() == null) {
                throw new Exception("caller principal is null");
            }
            if (!(sctx.getCallerPrincipal() instanceof UserPrincipal)) {
                throw new Exception("caller principal is of unexpected type:" + sctx.getCallerPrincipal().getClass().toString());
            }
            return (UserPrincipal)sctx.getCallerPrincipal();
        }
        catch (Exception e) {
            log.warn((Object)"Couldn't get UserPrincipal, returning empty UserPrincipal:", e, new String[0]);
            return null;
        }
    }

    public static String getUserNameFromSession(SessionContext sctx) {
        UserPrincipal userPrincipal = SessionContextUtil.getUserPrincipalFromSession(sctx);
        String userName = "";
        if (userPrincipal != null) {
            userName = userPrincipal.getName();
        } else if (sctx != null) {
            try {
                userName = sctx.getCallerPrincipal().getName();
            }
            catch (Exception e) {
                log.warn((Object)"Couldn't get general username, returning empty username:", e, new String[0]);
            }
            if (!StringUtils.isEmpty((String)userName)) {
                try {
                    PdsConnector connector = PdsConnector.getInstance();
                    PdsUserInfo userDetails = connector.getUserInfo(userName);
                    if (userDetails != null && userDetails.getUserName() != null) {
                        userName = userDetails.getUserName();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return userName;
    }

    public static HFrUser getUserFromSession(SessionContext sctx) {
        UserPrincipal userPrincipal = SessionContextUtil.getUserPrincipalFromSession(sctx);
        return userPrincipal == null ? null : userPrincipal.getUserDetails();
    }

    public static String getInstitutionPathFromSession(SessionContext sctx) {
        UserPrincipal userPrincipal = SessionContextUtil.getUserPrincipalFromSession(sctx);
        return userPrincipal == null ? "" : userPrincipal.getInstitutionPath();
    }

    public static boolean isCallerInRoleFromSession(SessionContext sctx, String role) {
        try {
            if (sctx == null) {
                throw new Exception("sctx is null");
            }
            return sctx.isCallerInRole(role);
        }
        catch (Exception e) {
            log.warn((Object)"Couldn't get isCallerInRole, returning false:", e, new String[0]);
            return false;
        }
    }

    public static boolean searchPrivilegeInContext(SessionContext sctx, String[] privileges) {
        if (privileges == null) {
            return false;
        }
        if (sctx == null) {
            return false;
        }
        for (String privilege : privileges) {
            if (!SessionContextUtil.isCallerInRoleFromSession(sctx, privilege)) continue;
            return true;
        }
        return false;
    }
}

