/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.ws;

import com.exlibris.core.infra.model.codetables.HMappingTables;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.ws.IPRange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RestrictedIPChecker {
    private static RestrictedIPChecker instance = new RestrictedIPChecker();
    private Map<String, List<IPRange>> allowedIPRangeByWSName = new HashMap<String, List<IPRange>>();
    private CodeTablesManager codeTablesManager = null;

    private RestrictedIPChecker() {
        this.getCodeTablesManager();
    }

    public static synchronized RestrictedIPChecker getInstance() {
        return instance;
    }

    public Boolean checkAccess(String remoteIp, String serviceName) {
        this.loadCodeTableConfiguration(serviceName);
        if (!this.allowedIPRangeByWSName.containsKey(serviceName)) {
            return false;
        }
        for (IPRange ipRange : this.allowedIPRangeByWSName.get(serviceName)) {
            if (!ipRange.inRange(remoteIp).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private synchronized void loadCodeTableConfiguration(String serviceName) {
        if (this.allowedIPRangeByWSName.containsKey(serviceName)) {
            return;
        }
        List<HMappingTables> mTables = this.getCodeTablesManager().findMappingsByTableNameAndTarget("IPRestriction", serviceName);
        if (mTables != null && !mTables.isEmpty()) {
            this.allowedIPRangeByWSName.put(serviceName, new ArrayList());
            for (HMappingTables mTable : mTables) {
                this.allowedIPRangeByWSName.get(serviceName).add(new IPRange(mTable.getSourceCode1()));
            }
        }
    }

    private CodeTablesManager getCodeTablesManager() {
        if (this.codeTablesManager == null) {
            this.codeTablesManager = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        }
        return this.codeTablesManager;
    }
}

