/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.ws;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.ws.RestrictedIPChecker;
import javax.annotation.Resource;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.servlet.http.HttpServletRequest;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;

public class WSRestrictedIpAccess {
    WebServiceContext wsContext;
    private static final ExLogger log = ExLogger.getExLogger(WSRestrictedIpAccess.class);

    @Resource
    public void setContext(WebServiceContext context) {
        this.wsContext = context;
    }

    @AroundInvoke
    @WebMethod(exclude=true)
    public Object restrictedIpInterceptor(InvocationContext ctx) throws Exception {
        if (!this.isWebMethod(ctx).booleanValue() || this.wsContext == null) {
            return ctx.proceed();
        }
        String remoteIp = this.getRemoteIp(ctx);
        if (!RestrictedIPChecker.getInstance().checkAccess(remoteIp, this.getWebServiceName(ctx)).booleanValue()) {
            throw new SecurityException(this.getClassAndFunctionName(ctx) + "Did Not Granted Authorization To Ip: " + remoteIp);
        }
        log.debug((Object)(this.getClassAndFunctionName(ctx) + "Granted Authorization To Ip: " + remoteIp), new String[0]);
        return ctx.proceed();
    }

    private Boolean isWebMethod(InvocationContext ctx) {
        WebMethod webMethod = ctx.getMethod().getAnnotation(WebMethod.class);
        if (webMethod == null) {
            return false;
        }
        if (this.getRemoteIp(ctx) == null) {
            return false;
        }
        return !webMethod.exclude();
    }

    private String getRemoteIp(InvocationContext ctx) {
        MessageContext mc = null;
        try {
            mc = this.wsContext.getMessageContext();
        }
        catch (Exception e) {
            return null;
        }
        HttpServletRequest request = (HttpServletRequest)mc.get((Object)"javax.xml.ws.servlet.request");
        return request.getRemoteAddr();
    }

    private String getWebServiceName(InvocationContext ctx) {
        return ctx.getTarget().getClass().getAnnotation(WebService.class).name();
    }

    private String getClassAndFunctionName(InvocationContext ctx) {
        return ctx.getTarget().getClass().getSimpleName() + "." + ctx.getMethod().getName() + " ";
    }
}

