/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.cron;

import com.exlibris.core.infra.Common;
import com.exlibris.core.infra.svc.api.CodeTablesResourceBundle;
import com.exlibris.core.infra.svc.api.common.DateHandler;
import com.exlibris.core.sdk.cron.CronObject;
import com.exlibris.core.sdk.cron.PeriodObject;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.quartz.CronTrigger;

public class CronUtil {
    private static SimpleDateFormat DOW_FMT = null;
    private static SimpleDateFormat MONTH_FMT = null;
    private static final String MSG_KEY_PREFIX = "ui.process.cron.";

    public static boolean checkValidation(CronObject cronObject, Common.SchedulingMode schedulingMode) {
        return CronUtil.checkValidation(cronObject, schedulingMode, null, null, new ArrayList<String>());
    }

    public static boolean checkValidation(CronObject cronObject, Common.SchedulingMode schedulingMode, Date startDate, Date endDate, List<String> errorKeyMsgs) {
        boolean isValid = true;
        if (errorKeyMsgs == null) {
            throw new IllegalArgumentException("errorMessages cannot be null");
        }
        if (schedulingMode == Common.SchedulingMode.WEEKLY && cronObject.getDayOfweekObject().getPeriods()[0].equals("?")) {
            errorKeyMsgs.add("ui.quartz.jobs.msg.dayOfWeekMissing");
            isValid = false;
        }
        Date now = new Date();
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            errorKeyMsgs.add("ui.quartz.jobs.msg.startDateBeforeEndDate");
            isValid = false;
        } else if (endDate != null && now.after(endDate)) {
            errorKeyMsgs.add("ui.quartz.jobs.msg.datesInPast");
            isValid = false;
        }
        return isValid;
    }

    public static String createExpressionFromCron(CronObject cronObject, Common.SchedulingMode schedulingMode) throws Exception {
        CronObject cronTmp;
        if (cronObject == null || schedulingMode == null) {
            throw new IllegalArgumentException("CronObject and SchedulingMode cannot be null");
        }
        if (!CronUtil.checkValidation(cronObject, schedulingMode)) {
            throw new Exception("Try to createExpressionFromCron but scheduling is not valid");
        }
        try {
            cronTmp = cronObject.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("CronObject class doesn't support 'clone()'", e);
        }
        String cronExpression = "";
        if (schedulingMode == Common.SchedulingMode.ASAP) {
            cronExpression = null;
        } else if (schedulingMode == Common.SchedulingMode.ONCE) {
            cronTmp.setSecond("00");
            cronTmp.setHourInterval(null);
            cronExpression = CronUtil.createExpressionFromCron(cronTmp, false);
        } else if (schedulingMode == Common.SchedulingMode.HOURLY) {
            cronTmp.setSecond("00");
            cronTmp.setDay("*");
            cronTmp.setMonth("*");
            cronTmp.setYear("*");
            cronExpression = CronUtil.createExpressionFromCron(cronTmp, false);
        } else if (schedulingMode == Common.SchedulingMode.DAILY) {
            cronTmp.setSecond("00");
            cronTmp.setHourInterval(null);
            cronTmp.setDay("*");
            cronTmp.setMonth("*");
            cronTmp.setYear("*");
            cronExpression = CronUtil.createExpressionFromCron(cronTmp, false);
        } else if (schedulingMode == Common.SchedulingMode.WEEKLY) {
            cronTmp.setSecond("00");
            cronTmp.setHourInterval(null);
            cronTmp.setDay("*");
            cronTmp.setMonth("*");
            cronTmp.setYear("*");
            cronExpression = CronUtil.createExpressionFromCron(cronTmp, true);
        } else if (schedulingMode == Common.SchedulingMode.MONTHLY) {
            cronTmp.setSecond("00");
            cronTmp.setHourInterval(null);
            cronTmp.setMonth("*");
            cronTmp.setYear("*");
            cronExpression = CronUtil.createExpressionFromCron(cronTmp, false);
        } else if (schedulingMode == Common.SchedulingMode.ADVANCE) {
            // empty if block
        }
        return cronExpression;
    }

    private static String createExpressionFromCron(CronObject cronObject, boolean isTreatDayOfWeek) throws Exception {
        String expression;
        String dayOfWeek;
        String day;
        String second = CronUtil.covertStringToLongString(cronObject.getSecond());
        String minute = CronUtil.covertStringToLongString(cronObject.getMinute());
        String hour = CronUtil.covertStringToLongString(cronObject.getHour());
        String hourInterval = cronObject.getHourInterval();
        if (StringUtils.isNotEmpty((String)hourInterval)) {
            hour = hour + "/" + hourInterval;
        }
        if (!isTreatDayOfWeek) {
            day = CronUtil.fillRange(1, 31, cronObject.getDayObject().isAllPeriods(), cronObject.getDayObject().getPeriods());
            dayOfWeek = "?";
        } else {
            day = "?";
            dayOfWeek = CronUtil.fillRange(1, 7, cronObject.getDayOfweekObject().isAllPeriods(), cronObject.getDayOfweekObject().getPeriods());
        }
        String month = CronUtil.fillRange(1, 12, cronObject.getMonthObject().isAllPeriods(), cronObject.getMonthObject().getPeriods());
        String year = cronObject.getYear();
        StringBuilder expressionSB = new StringBuilder().append(second).append(" ").append(minute).append(" ").append(hour).append(" ").append(day).append(" ").append(month).append(" ").append(dayOfWeek);
        if (StringUtils.isNotEmpty((String)year)) {
            expressionSB.append(" ").append(year);
        }
        if (!CronUtil.isExpersionValid(expression = expressionSB.toString())) {
            throw new Exception("Try to 'createExpressionFromCron' but expersion not valid");
        }
        return expression;
    }

    public static CronObject createCronFromExpression(String expression) throws Exception {
        String hourInterval;
        if (StringUtils.isEmpty((String)expression)) {
            throw new IllegalArgumentException("CronExpression cannot be empty");
        }
        if (!CronUtil.isExpersionValid(expression)) {
            throw new Exception("Try to 'createCronFromExpression' but expersion not valid");
        }
        String[] expressionArray = expression.split(" ");
        String second = expressionArray[0];
        String minute = expressionArray[1];
        String hour = expressionArray[2];
        String day = expressionArray[3];
        String month = expressionArray[4];
        String dayOfweek = expressionArray[5];
        String year = expressionArray.length > 6 ? expressionArray[6] : "*";
        String[] hourArray = hour.split("/");
        if (hourArray.length == 2) {
            hour = hourArray[0];
            hourInterval = hourArray[1];
        } else {
            hourInterval = null;
        }
        CronObject cronObject = new CronObject();
        cronObject.setSecond(second);
        cronObject.setMinute(minute);
        cronObject.setHour(hour);
        cronObject.setHourInterval(hourInterval);
        cronObject.setDayObject(CronUtil.getArrayFromAllowedValues(1, 31, day));
        cronObject.setMonthObject(CronUtil.getArrayFromAllowedValues(1, 12, month));
        cronObject.setDayOfweekObject(CronUtil.getArrayFromAllowedValues(1, 7, dayOfweek));
        cronObject.setYear(year);
        return cronObject;
    }

    private static boolean isExpersionValid(String expression) {
        boolean isValid = true;
        try {
            if (StringUtils.isNotEmpty((String)expression)) {
                new CronTrigger().setCronExpression(expression);
            } else {
                isValid = false;
            }
        }
        catch (ParseException e) {
            isValid = false;
        }
        return isValid;
    }

    private static String fillRange(int min, int max, boolean fullRange, String[] array) {
        String buffer = "";
        if (fullRange) {
            buffer = "*";
        } else {
            buffer = buffer + CronUtil.covertStringToLongString(array[0]);
            for (int i = 1; i < array.length; ++i) {
                buffer = buffer + "," + CronUtil.covertStringToLongString(array[i]);
            }
        }
        return buffer;
    }

    private static PeriodObject getArrayFromAllowedValues(int min, int max, String allowedValues) {
        PeriodObject period = new PeriodObject(max);
        String[] array = null;
        int length = max - min;
        if (allowedValues.contains("?")) {
            array = new String[]{allowedValues};
        } else if (allowedValues.contains("-") || allowedValues.equals("*")) {
            array = new String[length];
            for (int i = 0; i < length; ++i) {
                array[i] = String.valueOf(min + i);
            }
            period.setAllPeriods(true);
        } else {
            array = allowedValues.contains(",") ? allowedValues.split(",") : new String[]{allowedValues};
        }
        if (array.length == 1) {
            period.setPeriod(array[0]);
        } else if (array.length == max - 1) {
            period.setPeriod("*");
        } else {
            period.setPeriod(allowedValues);
        }
        period.setPeriods(array);
        return period;
    }

    private static String covertStringToLongString(String longString) {
        Long strToLong = null;
        try {
            strToLong = Long.parseLong(longString);
        }
        catch (Exception e) {
            return longString;
        }
        return strToLong.toString();
    }

    public static String formatScheduleString(Common.SchedulingMode scheduling, String cronExpression, Locale locale) throws Exception {
        if (locale == null) {
            locale = Locale.US;
        }
        Object[] params = new Object[]{};
        if (cronExpression == null || scheduling == null) {
            scheduling = Common.SchedulingMode.ASAP;
        } else if (scheduling == Common.SchedulingMode.ADVANCE) {
            params = new Object[]{cronExpression};
        } else {
            Date cronTime;
            CronObject cronObject = CronUtil.createCronFromExpression(cronExpression);
            if (scheduling == Common.SchedulingMode.ONCE) {
                params = new Object[2];
                Date cronDate = CronUtil.getCronDate(cronObject);
                params[0] = DateHandler.formatDate(cronDate);
                params[1] = DateHandler.getTimeFormatter().format(cronDate);
            } else if (scheduling == Common.SchedulingMode.HOURLY) {
                params = new Object[]{cronObject.getHourInterval()};
            } else if (scheduling == Common.SchedulingMode.DAILY) {
                params = new Object[1];
                cronTime = CronUtil.getCronTime(cronObject);
                params[0] = DateHandler.getTimeFormatter().format(cronTime);
            } else if (scheduling == Common.SchedulingMode.WEEKLY) {
                params = new Object[2];
                cronTime = CronUtil.getCronTime(cronObject);
                params[0] = CronUtil.getDayOfWeek(cronObject.getDayOfweek(), locale);
                params[1] = DateHandler.getTimeFormatter().format(cronTime);
            } else if (scheduling == Common.SchedulingMode.MONTHLY) {
                params = new Object[3];
                cronTime = CronUtil.getCronTime(cronObject);
                params[0] = CronUtil.getMonth(cronObject.getMonth(), locale);
                params[1] = CronUtil.getDayWithDow(cronObject.getDay(), cronObject.getDayOfweek(), locale);
                params[2] = DateHandler.getTimeFormatter().format(cronTime);
            }
        }
        String key = MSG_KEY_PREFIX + scheduling.name().toLowerCase();
        String message = CronUtil.getLocalizedMessage(key, params, locale);
        return message;
    }

    private static String getLocalizedMessage(String key, Object[] params, Locale locale) {
        ResourceBundle resourceBundle = CodeTablesResourceBundle.getDefaultBundle(locale);
        String message = resourceBundle.getString(key);
        message = MessageFormat.format(message, params);
        return message;
    }

    private static Date getCronDate(CronObject cron) {
        Calendar cal = Calendar.getInstance();
        cal.set(Integer.parseInt(cron.getYear()), Integer.parseInt(cron.getMonth()) - 1, Integer.parseInt(cron.getDay()), Integer.parseInt(cron.getHour()), Integer.parseInt(cron.getMinute()), Integer.parseInt(cron.getSecond()));
        return cal.getTime();
    }

    private static Date getCronTime(CronObject cron) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, Integer.parseInt(cron.getHour()));
        cal.set(12, Integer.parseInt(cron.getMinute()));
        cal.set(13, Integer.parseInt(cron.getSecond()));
        return cal.getTime();
    }

    private static String getDayWithDow(String day, String dayOfWeek, Locale locale) {
        StringBuffer buffer = new StringBuffer(25);
        if (!day.equals("?")) {
            buffer.append(day);
        }
        if (!dayOfWeek.equals("?")) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(CronUtil.getDayOfWeek(dayOfWeek, locale));
        }
        return buffer.toString();
    }

    private static String getDayOfWeek(String dayOfWeek, Locale locale) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.set(7, Integer.parseInt(dayOfWeek));
            DateFormat format = CronUtil.getDowFmt(locale);
            return format.format(cal.getTime());
        }
        catch (NumberFormatException nfe) {
            return dayOfWeek;
        }
    }

    private static String getMonth(String month, Locale locale) {
        try {
            if (StringUtils.isEmpty((String)month) || month.equals("*")) {
                return "month";
            }
            Calendar cal = Calendar.getInstance();
            cal.set(2, Integer.parseInt(month) - 1);
            DateFormat format = CronUtil.getMonthFmt(locale);
            return format.format(cal.getTime());
        }
        catch (NumberFormatException nfe) {
            return month;
        }
    }

    private static synchronized DateFormat getDowFmt(Locale locale) {
        if (DOW_FMT == null) {
            DOW_FMT = new SimpleDateFormat("EEEE", locale);
        }
        return DOW_FMT;
    }

    private static synchronized DateFormat getMonthFmt(Locale locale) {
        if (MONTH_FMT == null) {
            MONTH_FMT = new SimpleDateFormat("MMMM", locale);
        }
        return MONTH_FMT;
    }
}

