/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.mimetypes;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.digitool.common.mimetypes.xmlbeans.MediaType;
import com.exlibris.digitool.common.mimetypes.xmlbeans.MediaTypes;
import com.exlibris.digitool.common.mimetypes.xmlbeans.MnConfigurationDocument;
import java.io.InputStream;
import java.util.Hashtable;

public class MimeTypesConfigurationManager {
    public static final String ANY = "any";
    private static final ExLogger log = ExLogger.getExLogger(MimeTypesConfigurationManager.class);
    private static final String DEFAULT_ICON = "ico_unknown.gif";
    private static final String DEFAULT_ICON_DIS = "ico_unknown_dis.gif";
    private static MimeTypesConfigurationManager rpc;
    private MnConfigurationDocument mpcd = null;
    private Hashtable mimeType2icon = new Hashtable();
    private Hashtable mimeType2icondis = new Hashtable();
    private Hashtable code2icon = new Hashtable();
    private Hashtable code2icondis = new Hashtable();
    private Hashtable entityType2icon = new Hashtable();
    private Hashtable entityType2icondis = new Hashtable();
    private boolean isInit = false;
    private static final String CONF_FILE = "mimetypes_configuration.xml";

    private MimeTypesConfigurationManager() {
    }

    public static MimeTypesConfigurationManager getInstance() {
        if (rpc == null) {
            rpc = new MimeTypesConfigurationManager();
            rpc.load();
        }
        return rpc;
    }

    public static void main(String[] args) {
        new MimeTypesConfigurationManager().load();
    }

    private void loadMimeTypes() {
        MediaTypes medias = this.mpcd.getMnConfiguration().getMediaTypes();
        if (medias == null) {
            return;
        }
        MediaType[] media = medias.getMediaTypeArray();
        for (int i = 0; i < media.length; ++i) {
            if (media[i].getMimetype() != null) {
                this.mimeType2icon.put(media[i].getMimetype().trim().toLowerCase(), media[i].getIcon());
                this.mimeType2icondis.put(media[i].getMimetype().trim().toLowerCase(), media[i].getIconDis());
            }
            if (media[i].getCode() != null) {
                this.code2icon.put(media[i].getCode().trim().toLowerCase(), media[i].getIcon());
                this.code2icondis.put(media[i].getCode().trim().toLowerCase(), media[i].getIconDis());
            }
            if (media[i].getEntityType() == null) continue;
            this.entityType2icon.put(media[i].getEntityType().trim().toLowerCase(), media[i].getIcon());
            this.entityType2icondis.put(media[i].getEntityType().trim().toLowerCase(), media[i].getIconDis());
        }
    }

    public String getIcon(String mimeType, String entityType) {
        String icon = null;
        if (entityType == null) {
            return this.getIcon(mimeType);
        }
        icon = (String)this.entityType2icon.get(entityType.trim().toLowerCase());
        if (icon == null) {
            return this.getIcon(mimeType);
        }
        return icon;
    }

    public String getIcon(String mimeType) {
        String icon = null;
        if (mimeType == null) {
            return DEFAULT_ICON;
        }
        icon = (String)this.mimeType2icon.get(mimeType.trim().toLowerCase());
        if (icon == null) {
            return DEFAULT_ICON;
        }
        return icon;
    }

    public String getIconDis(String mimeType, String entityType) {
        String icon = null;
        if (entityType == null) {
            return this.getIconDis(mimeType);
        }
        icon = (String)this.entityType2icondis.get(entityType.trim().toLowerCase());
        if (icon == null) {
            return this.getIconDis(mimeType);
        }
        return icon;
    }

    public String getIconDis(String mimeType) {
        String icon = null;
        if (mimeType == null) {
            return DEFAULT_ICON_DIS;
        }
        icon = (String)this.mimeType2icondis.get(mimeType.trim().toLowerCase());
        if (icon == null) {
            return DEFAULT_ICON_DIS;
        }
        return icon;
    }

    public String getIconByCode(String code) {
        String icon = null;
        if (code == null) {
            return icon;
        }
        icon = (String)this.code2icon.get(code.trim().toLowerCase());
        return icon;
    }

    public String getIconDisByCode(String code) {
        String icon = null;
        if (code == null) {
            return icon;
        }
        icon = (String)this.code2icondis.get(code.trim().toLowerCase());
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        InputStream in = null;
        try {
            log.info("Looking for mimetypes configuration file: mimetypes_configuration.xml ...");
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(CONF_FILE);
            if (in == null) {
                log.error("Mimetypes Configuration file not found." + in, new String[0]);
            }
            log.info("Mimetypes configuration file found.");
            this.mpcd = MnConfigurationDocument.Factory.parse(in);
            this.loadMimeTypes();
            this.isInit = true;
            log.info("Mimetypes setting loaded");
        }
        catch (Throwable e) {
            try {
                log.error("Failed to load mimetypes configuration from mimetypes_configuration.xml: " + e.getMessage() + e.getLocalizedMessage() + e.getCause(), new String[0]);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(in);
                throw throwable;
            }
            IOUtil.closeQuietly(in);
        }
        IOUtil.closeQuietly(in);
    }

    public boolean isInit() {
        return this.isInit;
    }
}

