/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.storage.containers;

import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.storage.Fixity;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class StoredEntityMetaData {
    private EntityType entityType;
    private String currentFilePath;
    private Long sizeInBytes = 0L;
    private String entityPid;
    private String fileExstention;
    private DnxDocument ieDnx;
    private DnxDocument repDnx;
    private DnxDocument fileDnx;
    private List<DnxDocument> extraDnxs;
    private List<Fixity> fixities;
    private Integer version;

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public String getEntityPid() {
        return this.entityPid;
    }

    public void setSizeInBytes(String sizeInBytes) {
        if (!StringUtils.isBlank((String)sizeInBytes)) {
            this.sizeInBytes = Long.parseLong(sizeInBytes);
        }
    }

    public void setEntityPid(String entityPid) {
        this.entityPid = entityPid;
    }

    public String getFileExstention() {
        return this.fileExstention;
    }

    public void setFileExstention(String fileExstention) {
        this.fileExstention = fileExstention;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setIeDnx(DnxDocument ieDnx) {
        this.ieDnx = ieDnx;
    }

    public DnxDocument getIeDnx() {
        return this.ieDnx;
    }

    public void setRepDnx(DnxDocument repDnx) {
        this.repDnx = repDnx;
    }

    public DnxDocument getRepDnx() {
        return this.repDnx;
    }

    public void setFileDnx(DnxDocument fileDnx) {
        this.fileDnx = fileDnx;
    }

    public DnxDocument getFileDnx() {
        return this.fileDnx;
    }

    public void setCurrentFilePath(String currentFilePath) {
        this.currentFilePath = currentFilePath;
    }

    public String getCurrentFilePath() {
        return this.currentFilePath;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getFixityByType(String fixityType) {
        for (Fixity fixity : this.fixities) {
            if (!fixity.getAlgorithm().equals(fixityType)) continue;
            return fixity.getValue();
        }
        return null;
    }

    public void setExtraDnxs(List<DnxDocument> extraDnxs) {
        this.extraDnxs = extraDnxs;
    }

    public List<DnxDocument> getExtraDnxs() {
        return this.extraDnxs;
    }

    public void setFixities(List<Fixity> fixities) {
        this.fixities = fixities;
    }

    public List<Fixity> getFixities() {
        return this.fixities;
    }

    public static enum EntityType {
        IE,
        FILE,
        MD,
        SIP;

    }
}

