/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils;

import com.exlibris.core.infra.common.shared.dataObjects.KeyValuePair;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.sdk.utils.FSDirUtil;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.core.sdk.utils.FolderUtil;
import com.exlibris.core.sdk.utils.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;

public class SipDirUtil
extends FolderUtil {
    public static final String PREMIS_XML = "premis.xml";
    public static final String PARAMS_XML = "params.xml";
    public static final String DC_XML = "dc.xml";
    public static final String DNX_XML = "MDdnx.xml";
    public static final String PRODUCER_XML = "producer.xml";
    public static final String SIP_DIR = "sip";
    public static final String IES_DIR = "ies";
    public static final String SHARED_DIR = "shared";
    public static final String SOURCE_XML_PREFIX = "source_";
    public static final String CONNECTOR = "_";
    protected String m_sipDir = this.m_folderDir + "sip" + FSDirUtil.SEPARATOR;
    protected String m_iesDir = this.m_sipDir + "ies" + FSDirUtil.SEPARATOR;
    protected String m_sharedDir = this.m_sipDir + "shared" + FSDirUtil.SEPARATOR;
    private final int IES_PER_BULK = 1000;
    private final String IE = "ie";
    private final String BULK_IE = "bulk_ie";
    private final String ZIPPED_IE = "ies";

    public SipDirUtil(String folderDir, String folderId) {
        super(folderDir, folderId);
    }

    public String getSipDirName() {
        return this.m_sipDir;
    }

    public String getIesDirName() {
        return this.m_iesDir;
    }

    public String getSharedDirName() {
        return this.m_sharedDir;
    }

    @Override
    public boolean createNewDirStructure() {
        FileUtil.createFile(this.m_sipDir);
        FileUtil.createFile(this.m_iesDir);
        FileUtil.createFile(this.m_sharedDir);
        return true;
    }

    @Override
    public void deleteDirStructure() throws IOException {
        FileUtil.forceDelete(this.m_folderDir);
    }

    @Override
    public void resetDirStructure() throws IOException {
        this.deleteDirStructure();
        this.createNewDirStructure();
    }

    public boolean addFileToSip(String sourcePath, depositDirectories targetDir) throws IOException {
        switch (targetDir) {
            case IES_DIR: {
                return this.addFile(sourcePath, this.m_iesDir);
            }
            case SHARED_DIR: {
                return this.addFile(sourcePath, this.m_sharedDir);
            }
        }
        return false;
    }

    public boolean addFileToSip(File sourcePath, depositDirectories targetDir) throws IOException {
        switch (targetDir) {
            case IES_DIR: {
                return this.addFile(sourcePath, this.m_iesDir);
            }
            case SHARED_DIR: {
                return this.addFile(sourcePath, this.m_sharedDir);
            }
        }
        return false;
    }

    public boolean addFileToSip(InputStream source, String fileName, depositDirectories targetDir) throws IOException {
        switch (targetDir) {
            case IES_DIR: {
                return this.addFile(source, fileName, this.m_iesDir);
            }
            case SHARED_DIR: {
                return this.addFile(source, fileName, this.m_sharedDir);
            }
        }
        return false;
    }

    public boolean addFileToSip(String fileContents, String fileNameWithExt, depositDirectories targetDir) throws IOException {
        switch (targetDir) {
            case IES_DIR: {
                return this.addFile(fileContents, fileNameWithExt, this.m_iesDir);
            }
            case SHARED_DIR: {
                return this.addFile(fileContents, fileNameWithExt, this.m_sharedDir);
            }
        }
        return false;
    }

    public boolean addFilesToSip(String[] files, depositDirectories targetDir) throws IOException {
        switch (targetDir) {
            case IES_DIR: {
                return this.addFiles(files, this.m_iesDir);
            }
            case SHARED_DIR: {
                return this.addFiles(files, this.m_sharedDir);
            }
        }
        return false;
    }

    public boolean addFilesToSip(List files, depositDirectories targetDir) throws IOException {
        switch (targetDir) {
            case IES_DIR: {
                return this.addFiles(files, this.m_iesDir);
            }
            case SHARED_DIR: {
                return this.addFiles(files, this.m_sharedDir);
            }
        }
        return false;
    }

    public boolean removeAllFilesFromSipDir(depositDirectories targetDir) throws IOException {
        switch (targetDir) {
            case IES_DIR: {
                return this.removeAllFiles(this.m_iesDir);
            }
            case SHARED_DIR: {
                return this.removeAllFiles(this.m_sharedDir);
            }
        }
        return false;
    }

    public boolean removeFileFromSip(String fileName, depositDirectories targetDir) throws IOException {
        switch (targetDir) {
            case IES_DIR: {
                return this.removeFile(fileName, this.m_iesDir);
            }
            case SHARED_DIR: {
                return this.removeFile(fileName, this.m_sharedDir);
            }
        }
        return false;
    }

    public File[] getAllFilesFromSip(depositDirectories targetDir) {
        switch (targetDir) {
            case IES_DIR: {
                return this.getAllFiles(this.m_iesDir);
            }
            case SHARED_DIR: {
                return this.getAllFiles(this.m_sharedDir);
            }
        }
        return null;
    }

    public long getFilesSizeFromDeposit(depositDirectories targetDir) {
        switch (targetDir) {
            case IES_DIR: {
                return this.getFilesSize(this.m_iesDir);
            }
            case SHARED_DIR: {
                return this.getFilesSize(this.m_sharedDir);
            }
        }
        return 0L;
    }

    public File getFileFromDeposit(String name, depositDirectories targetDir) {
        switch (targetDir) {
            case IES_DIR: {
                return this.getFile(name, this.m_iesDir);
            }
            case SHARED_DIR: {
                return this.getFile(name, this.m_sharedDir);
            }
        }
        return null;
    }

    public boolean addIesFile(String fileContents) throws IOException {
        String bulk_directory_name = null;
        String ieName = null;
        File[] files = this.getAllDirectories(this.m_iesDir);
        for (int i = 0; i < files.length; ++i) {
            bulk_directory_name = files[i].getAbsolutePath() + FSDirUtil.SEPARATOR;
            if (this.getAllFiles(bulk_directory_name).length >= 1000) continue;
            ieName = "ie" + (this.getAllFiles(bulk_directory_name).length + 1) + ".xml";
            return this.addFile(fileContents, ieName, bulk_directory_name);
        }
        bulk_directory_name = this.m_iesDir + "bulk_ie" + files.length + FSDirUtil.SEPARATOR;
        FSDirUtil.createDirectory(bulk_directory_name);
        ieName = "ie1.xml";
        return this.addFile(fileContents, ieName, bulk_directory_name);
    }

    public boolean copyIesToIeDir(String ieFile, String ieFileName) throws IOException {
        String bulk_directory_name = null;
        File[] files = this.getAllDirectories(this.m_iesDir);
        for (int i = 0; i < files.length; ++i) {
            bulk_directory_name = files[i].getAbsolutePath() + FSDirUtil.SEPARATOR;
            if (this.getAllFiles(bulk_directory_name).length >= 1000) continue;
            return this.addFile(ieFile, ieFileName, bulk_directory_name);
        }
        bulk_directory_name = this.m_iesDir + "bulk_ie" + files.length + FSDirUtil.SEPARATOR;
        FSDirUtil.createDirectory(bulk_directory_name);
        return this.addFile(ieFile, ieFileName, bulk_directory_name);
    }

    public void zipIes() throws Exception {
        String zipName = null;
        File[] files = this.getAllDirectories(this.m_iesDir);
        for (int i = 0; i < files.length; ++i) {
            zipName = this.m_iesDir + IES_DIR + i + ".zip";
            ZipUtil.zipFlatDir(files[i].getAbsolutePath(), zipName);
            this.removeAllFiles(files[i].getAbsolutePath());
            this.removeDir(files[i].getAbsolutePath());
        }
    }

    public boolean addPremisFile(File sourcePath) throws IOException {
        String dest = sourcePath.getAbsolutePath().replaceFirst(sourcePath.getName(), PREMIS_XML);
        File tempFile = new File(dest);
        FileUtil.copyFile(sourcePath, tempFile);
        return this.addFile(tempFile, this.m_sharedDir);
    }

    public File getPremisFile() throws IOException {
        return this.getFile(PREMIS_XML, this.m_sharedDir);
    }

    public boolean addParamsXml(String fileContent) throws IOException {
        return this.addFile(fileContent, PARAMS_XML, this.m_sharedDir);
    }

    public File getParamsFile() throws IOException {
        return this.getFile(PARAMS_XML, this.m_sharedDir);
    }

    public boolean addDcFile(String fileContent) throws IOException {
        return this.addFile(fileContent, DC_XML, this.m_sharedDir);
    }

    public boolean addDnxFile(String fileContent) throws IOException {
        return this.addFile(fileContent, DNX_XML, this.m_sharedDir);
    }

    public File getDnxFile() throws IOException {
        return this.getFile(DNX_XML, this.m_sharedDir);
    }

    public File getDcFile() throws IOException {
        return this.getFile(DC_XML, this.m_sharedDir);
    }

    public boolean addProducerFile(String fileContent) throws IOException {
        return this.addFile(fileContent, PRODUCER_XML, this.m_sharedDir);
    }

    public File getProducerFile() throws IOException {
        return this.getFile(PRODUCER_XML, this.m_sharedDir);
    }

    public String[] getSourceFileNames() throws IOException {
        IOFileFilter filter1 = FileFileFilter.FILE;
        PrefixFileFilter filter2 = new PrefixFileFilter(SOURCE_XML_PREFIX);
        return new File(this.m_sharedDir).list((FilenameFilter)new AndFileFilter(filter1, (IOFileFilter)filter2));
    }

    public List<KeyValuePair<String, String>> getSourceMdFileNames() throws IOException {
        String[] sourceFileNames;
        ArrayList<KeyValuePair<String, String>> sourceMds = new ArrayList<KeyValuePair<String, String>>();
        for (String sourceFileName : sourceFileNames = this.getSourceFileNames()) {
            String mdType = this.getMdType(sourceFileName);
            String fileName = SipDirUtil.getOriginalFileName(sourceFileName);
            KeyValuePair<String, String> sourceMd = new KeyValuePair<String, String>(mdType, fileName);
            sourceMds.add(sourceMd);
        }
        return sourceMds;
    }

    public List<KeyValuePair<String, File>> getSourceMdFiles() throws IOException {
        String[] sourceFileNames;
        ArrayList<KeyValuePair<String, File>> sourceMds = new ArrayList<KeyValuePair<String, File>>();
        for (String sourceFileName : sourceFileNames = this.getSourceFileNames()) {
            File sourceFile = this.getFile(sourceFileName, this.m_sharedDir);
            String mdType = this.getMdType(sourceFileName);
            KeyValuePair<String, File> sourceMd = new KeyValuePair<String, File>(mdType, sourceFile);
            sourceMds.add(sourceMd);
        }
        return sourceMds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIeMdFile() throws IOException {
        File ieMd = this.getFile("ieMd.xml", this.getSharedDirName());
        String ieMdMets = null;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(ieMd);
            ieMdMets = IOUtil.toString(fin);
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(fin);
            throw throwable;
        }
        IOUtil.closeQuietly(fin);
        return ieMdMets;
    }

    private String getMdType(String sourceFileName) {
        int beginIndex = SOURCE_XML_PREFIX.length();
        int endIndex = sourceFileName.indexOf(CONNECTOR, beginIndex);
        String mdType = sourceFileName.substring(beginIndex, endIndex);
        return mdType;
    }

    public static String getSourceMdFileName(String sourceMdType, String originalFileName) {
        String fileNameWithExt = SOURCE_XML_PREFIX + sourceMdType + CONNECTOR + originalFileName;
        return fileNameWithExt;
    }

    public static String getOriginalFileName(String sourceFileName) {
        int beginIndex = SOURCE_XML_PREFIX.length();
        int endIndex = sourceFileName.indexOf(CONNECTOR, beginIndex);
        String fileName = sourceFileName.substring(endIndex + 1);
        return fileName;
    }

    public static enum depositDirectories {
        IES_DIR,
        SHARED_DIR;

    }
}

