/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.formatting.md;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.sdk.formatting.DublinCore;
import com.exlibris.core.sdk.formatting.DublinCoreFactory;
import com.exlibris.digitool.common.formatting.md.DescriptiveMDExtractor;
import com.exlibris.digitool.common.streams.UTF8FileInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DublinCoreMDExtractor
implements DescriptiveMDExtractor {
    private static final String MAIN_TAG = "record";
    private NodeList records = null;
    private static final ExLogger logger = ExLogger.getExLogger(DublinCoreMDExtractor.class);

    public DublinCoreMDExtractor() {
    }

    public DublinCoreMDExtractor(String fileName) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        UTF8FileInputStream fis = null;
        Document doc = null;
        try {
            fis = new UTF8FileInputStream(fileName);
            doc = factory.newDocumentBuilder().parse(fis);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (SAXException se) {
            throw se;
        }
        catch (ParserConfigurationException pe) {
            throw pe;
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception e) {}
        }
        this.records = doc.getDocumentElement().getElementsByTagName(MAIN_TAG);
    }

    @Override
    public Object[] getRecords() {
        Object[] dcRecords = new Object[this.records.getLength()];
        for (int i = 0; i < this.records.getLength(); ++i) {
            dcRecords[i] = this.records.item(i);
        }
        return dcRecords;
    }

    @Override
    public String extractData(Object record, String key) {
        String extractedData = "";
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource();
            source.setNode((Node)record);
            StreamResult result = new StreamResult();
            CharArrayWriter writer = new CharArrayWriter();
            result.setWriter(writer);
            transformer.transform(source, result);
            String xmlData = writer.toString();
            if (key == null) {
                return xmlData;
            }
            DublinCore dublinCore = DublinCoreFactory.getInstance().createDocument(xmlData);
            extractedData = dublinCore.getValue(key);
        }
        catch (Exception e) {
            logger.info(DescriptorConstants.IN_FailedReplaceValueInDE);
        }
        return extractedData;
    }

    @Override
    public String extractXMLData(Object record) {
        String value = this.extractData(record, null);
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" ?> " + value;
    }
}

