/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.formatting.md;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.digitool.common.formatting.Mods;
import com.exlibris.digitool.common.formatting.ModsFactory;
import com.exlibris.digitool.common.formatting.md.DescriptiveMDExtractor;
import com.exlibris.digitool.common.streams.UTF8FileInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ModsMDExtractor
implements DescriptiveMDExtractor {
    private static final String MAIN_TAG = "modsCollection";
    private static final String MAIN_TAG2 = "mods";
    private Element records = null;
    private static ExLogger logger = ExLogger.getExLogger(ModsMDExtractor.class);

    public ModsMDExtractor() {
    }

    public ModsMDExtractor(String fileName) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        UTF8FileInputStream fis = null;
        Document doc = null;
        try {
            fis = new UTF8FileInputStream(fileName);
            doc = factory.newDocumentBuilder().parse(fis);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (SAXException se) {
            throw se;
        }
        catch (ParserConfigurationException pe) {
            throw pe;
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception e) {}
        }
        this.records = doc.getDocumentElement();
        String prefix = doc.getDocumentElement().getTagName();
    }

    @Override
    public Object[] getRecords() {
        Object[] modsRecords = null;
        if (this.records.getTagName().equalsIgnoreCase(MAIN_TAG)) {
            NodeList rec = this.records.getElementsByTagName(MAIN_TAG2);
            modsRecords = new Object[rec.getLength()];
            for (int i = 0; i < rec.getLength(); ++i) {
                modsRecords[i] = rec.item(i);
            }
        } else {
            modsRecords = new Object[]{this.records};
        }
        return modsRecords;
    }

    @Override
    public String extractData(Object record, String key) {
        String extractedData = "";
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource();
            source.setNode((Node)record);
            StreamResult result = new StreamResult();
            CharArrayWriter writer = new CharArrayWriter();
            result.setWriter(writer);
            transformer.transform(source, result);
            String xmlData = writer.toString();
            if (key == null) {
                return xmlData;
            }
            Mods mods = ModsFactory.getInstance().createDocument(xmlData);
            extractedData = mods.getValue(key);
        }
        catch (Exception e) {
            logger.info(DescriptorConstants.IN_FailedReplaceValueInDE);
        }
        return extractedData;
    }

    @Override
    public String extractXMLData(Object record) {
        String value = this.extractData(record, null);
        return value;
    }
}

