/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.streams;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.streams.EncodingUtil;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.digitool.common.streams.ExternalProcessUtil;
import com.exlibris.digitool.common.streams.FailedToHandlerStreamException;
import com.exlibris.digitool.common.streams.StreamHandler;

public class DocumentTextExtractorStreamHandler
extends StreamHandler {
    private String fullTextShell = "/exlibris/app/oracle/product/920/ctx/bin/ctxhx";
    private static final ExLogger logger = ExLogger.getExLogger(DocumentTextExtractorStreamHandler.class);

    @Override
    public void handleStream() throws FailedToHandlerStreamException {
        if (this.params != null && this.params.length == 2) {
            try {
                Object[] workerParams = new Object[]{this.params[0], this.params[1]};
                new ExternalProcessUtil().execWorker(this.fullTextShell, this.paramsPattern, workerParams);
                if (FileUtil.getFileSize(this.params[1]) == 0L) {
                    logger.info(DescriptorConstants.IN_UnableToCreateStream, (Object)this.fullTextShell, (Object)"NONE", (Object)"File size is 0");
                    throw new FailedToHandlerStreamException("Failed to create the stream file size is 0");
                }
                EncodingUtil.convertUnicodeFileToUTF8File(this.params[1], this.params[1]);
            }
            catch (Exception e) {
                logger.info(DescriptorConstants.IN_UnableToCreateStream, (Object)this.fullTextShell, e.getClass(), (Object)e.getMessage());
                throw new FailedToHandlerStreamException("Failed to create the stream using " + this.fullTextShell + " Exception: " + e.getMessage());
            }
        } else {
            throw new FailedToHandlerStreamException("one of the following is missing: 'file to read', 'file to write'");
        }
    }
}

