/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.streams;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecExternalProcess;
import com.exlibris.core.sdk.strings.StringUtils;
import com.exlibris.core.sdk.utils.FSUtil;
import com.exlibris.digitool.common.streams.FailedToHandlerStreamException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class ExternalProcessUtil {
    private static final ExLogger logger = ExLogger.getExLogger(ExternalProcessUtil.class);

    public String execWorker(String worker, String paramsPattern, Object[] params) throws FailedToHandlerStreamException {
        if (params != null && params.length != 0) {
            Iterator<Object> paramsIter = Arrays.asList(params).iterator();
            int i = 1;
            try {
                while (paramsIter.hasNext()) {
                    paramsPattern = StringUtils.replaceSubString(paramsPattern, "$" + i++, (String)paramsIter.next());
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new FailedToHandlerStreamException();
            }
        }
        logger.info("Execute:" + worker + " " + paramsPattern);
        ExecExternalProcess proc = new ExecExternalProcess();
        Vector paramsVector = StringUtils.extractValues(paramsPattern, " ", false);
        LinkedList<String> args = new LinkedList<String>(paramsVector);
        int exitValue = proc.execExternalProcess(worker, args);
        if (exitValue == 0) {
            return proc.getInputStream();
        }
        logger.error(("Execute of " + worker + " with params " + paramsPattern + " failed , STDERR : " + proc.getErrorStream()).toString(), new String[0]);
        throw new FailedToHandlerStreamException("execute the program failed - exit value = " + exitValue + " output: " + proc.getErrorStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runScript(String scriptNameWithoutExtebnsion, String argsStr) {
        try {
            Process proc = null;
            String osName = System.getProperty("os.name");
            logger.info("Execute:" + scriptNameWithoutExtebnsion + " " + argsStr);
            if (osName.equals("Unix") || osName.equals("Linux") || osName.equals("SunOS")) {
                StringBuffer cmd = new StringBuffer();
                cmd.append(FSUtil.getSystemDir()).append("bin/" + scriptNameWithoutExtebnsion).append(FSUtil.getBatchExtention()).append(" ").append(argsStr);
                proc = Runtime.getRuntime().exec(cmd.toString(), null, new File(FSUtil.getSystemDir() + "bin"));
            } else {
                String[] commands = ("C:\\ng\\digitool\\home\\system\\bin\\" + scriptNameWithoutExtebnsion + ".bat " + argsStr).split(" ");
                String[] env = new String[]{"digitool_home=" + FSUtil.getSystemDir()};
                proc = Runtime.getRuntime().exec(commands, env, new File("C:\\ng\\digitool\\home\\system\\bin"));
            }
            InputStream is = proc.getInputStream();
            int len = 0;
            byte[] buf = new byte[1000];
            StringBuffer output = new StringBuffer();
            try {
                while ((len = is.read(buf)) != -1) {
                    String str = new String(buf, 0, len);
                    output.append(str);
                    System.out.print(str);
                }
            }
            catch (EOFException eof) {
                logger.info(DescriptorConstants.IN_FailedToGetExternalProgOutput, (Object)eof.getMessage());
            }
            catch (IOException ioe) {
                logger.info(DescriptorConstants.IN_FailedToGetExternalProgOutput, (Object)ioe.getMessage());
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    logger.info(DescriptorConstants.GN_UnableToCloseStream, (Object)ex.getMessage());
                }
            }
            proc.waitFor();
            if (proc.exitValue() == 0) {
                return output.toString();
            }
            return output.toString();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "";
        }
    }

    public static void main(String[] args) {
        String ud = System.getProperty("user.dir");
        System.out.println(ud);
        System.setProperty("user.dir", "C:\\ng\\digitool\\home\\system\\bin");
        String str = ExternalProcessUtil.runScript("job", "-jobid 2202");
        System.out.println(str);
    }
}

