/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.consts;

import com.exlibris.core.infra.svc.api.CodeTablesResourceBundle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.ResourceBundle;

public final class DepositStatusEnum
implements Serializable {
    private int id;
    private String statusName;
    public final int ord;
    private DepositStatusEnum prev;
    private DepositStatusEnum next;
    private static int upperBound = 0;
    private static DepositStatusEnum first = null;
    private static DepositStatusEnum last = null;
    private static final String MESSAGES_PROPERTIES = "i18n.messages";
    private static ResourceBundle resourceBundle = CodeTablesResourceBundle.getDefaultBundle(null);
    public static final DepositStatusEnum SUBMITTED = new DepositStatusEnum(0);
    public static final DepositStatusEnum APPROVED = new DepositStatusEnum(1);
    public static final DepositStatusEnum REJECTED = new DepositStatusEnum(2);
    public static final DepositStatusEnum DECLINED = new DepositStatusEnum(3);
    public static final DepositStatusEnum DRAFT = new DepositStatusEnum(4);
    public static final DepositStatusEnum RESUBMITTED = new DepositStatusEnum(5);
    public static final DepositStatusEnum UNDER_WORK = new DepositStatusEnum(6);

    private DepositStatusEnum(int anID) {
        this.id = anID;
        this.ord = upperBound++;
        if (first == null) {
            first = this;
        }
        if (last != null) {
            this.prev = last;
            DepositStatusEnum.last.next = this;
        }
        last = this;
    }

    public static Enumeration elements() {
        return new Enumeration(){
            private DepositStatusEnum curr = DepositStatusEnum.access$000();

            @Override
            public boolean hasMoreElements() {
                return this.curr != null;
            }

            public Object nextElement() {
                DepositStatusEnum c = this.curr;
                this.curr = this.curr.next();
                return c;
            }
        };
    }

    public static DepositStatusEnum valueOf(int id) {
        Enumeration enumeration = DepositStatusEnum.elements();
        while (enumeration.hasMoreElements()) {
            DepositStatusEnum depositStatusEnum = (DepositStatusEnum)enumeration.nextElement();
            if (depositStatusEnum == null) {
                return null;
            }
            if (depositStatusEnum.id != id) continue;
            return depositStatusEnum;
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public int toInt() {
        return this.id;
    }

    public Integer toInteger() {
        return new Integer(this.id);
    }

    public static int size() {
        return upperBound;
    }

    public static DepositStatusEnum first() {
        return first;
    }

    public static DepositStatusEnum last() {
        return last;
    }

    public DepositStatusEnum prev() {
        return this.prev;
    }

    public DepositStatusEnum next() {
        return this.next;
    }

    public String getStatusName() {
        String retString = null;
        if (this.id == DepositStatusEnum.APPROVED.id) {
            retString = "Approved";
        }
        if (this.id == DepositStatusEnum.REJECTED.id) {
            retString = "Returned";
        }
        if (this.id == DepositStatusEnum.DECLINED.id) {
            retString = "Declined";
        }
        if (this.id == DepositStatusEnum.DRAFT.id) {
            retString = "Draft";
        }
        if (this.id == DepositStatusEnum.SUBMITTED.id) {
            retString = "Submitted";
        }
        if (this.id == DepositStatusEnum.RESUBMITTED.id) {
            retString = "Resubmitted";
        }
        if (this.id == DepositStatusEnum.UNDER_WORK.id) {
            retString = "UnderWork";
        }
        if (retString == null) {
            return null;
        }
        try {
            retString = resourceBundle.getString("d.status." + retString.toLowerCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retString;
    }

    static /* synthetic */ DepositStatusEnum access$000() {
        return first;
    }
}

