/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.fsutils;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.digitool.exceptions.DigitoolException;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class DeliveryStreamCacheUtil {
    private static final long serialVersionUID = 20090303183019L;
    private static final String DELIVERY_STREAM_CACHE_DIR_NAME = "delivery_stream_cache";
    public static final CachePolicy DEFAULT_CACHE_POLICY = CachePolicy.NO;

    public static final CachePolicy getCachePolicy() {
        GeneralParameterManager genParamMng = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        String cachePolicy = genParamMng.getParameter("delivery", "delivery_stream_cache_mode");
        if (StringUtils.isBlank((String)cachePolicy)) {
            return DEFAULT_CACHE_POLICY;
        }
        CachePolicy currCachePolicy = CachePolicy.valueOf(cachePolicy.toUpperCase());
        return currCachePolicy;
    }

    public static final String getCacheLocation() throws DigitoolException {
        GeneralParameterManager genParamMng = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        String cacheLocation = genParamMng.getParameter("general", "operational_shared") + File.separator + "operational_delivery_shared" + File.separator;
        if (StringUtils.isBlank((String)cacheLocation)) {
            throw new DigitoolException(DescriptorConstants.GN_CannotFindGeneralParameter, (Object)"general", "operational_shared");
        }
        if (!cacheLocation.endsWith(File.separator)) {
            cacheLocation = cacheLocation + File.separator;
        }
        return cacheLocation + DELIVERY_STREAM_CACHE_DIR_NAME + File.separator;
    }

    public static final String getFilePathInCache(String filePid, String fileName) throws DigitoolException {
        if (StringUtils.isBlank((String)filePid) || filePid.trim().length() <= 5) {
            throw new DigitoolException(DescriptorConstants.GN_UnexpectedError, "Invalid PID");
        }
        if (StringUtils.isBlank((String)fileName)) {
            throw new DigitoolException(DescriptorConstants.GN_UnexpectedError, "Invalid file name");
        }
        String tempFileLocation = filePid.substring(5);
        tempFileLocation = StringUtils.reverse((String)tempFileLocation);
        String newFileLocation = "";
        for (int i = 0; i < tempFileLocation.length(); ++i) {
            newFileLocation = newFileLocation + tempFileLocation.charAt(i) + File.separator;
        }
        File newFileParentDir = new File(DeliveryStreamCacheUtil.getCacheLocation() + newFileLocation);
        if (!newFileParentDir.exists()) {
            newFileParentDir.mkdirs();
        }
        return newFileParentDir.getAbsolutePath() + File.separator + fileName;
    }

    public static final boolean isCacheEnabled() {
        return !DeliveryStreamCacheUtil.getCachePolicy().equals((Object)CachePolicy.NO);
    }

    public static enum CachePolicy {
        YES,
        ONLY_FROM_PERMANENT,
        NO;

    }
}

