/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.infrastructure.utils;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.digitool.common.streams.ExternalProcessUtil;
import com.exlibris.digitool.common.streams.FailedToHandlerStreamException;
import com.exlibris.digitool.common.streams.StreamHandler;
import com.exlibris.digitool.common.streams.StreamHandlerUtil;
import com.exlibris.digitool.common.streams.StreamHandlersMngr;
import com.exlibris.digitool.exceptions.DigitoolException;

public class StreamHandlerFacade {
    public static final String FILE_NOT_MATCH = "file not match";
    public static final String TASK_THUMBNAIL = "Thumbnail";
    public static final String JP2000 = "Jp2000";
    private static final ExLogger log = ExLogger.getExLogger(StreamHandlerFacade.class);
    private static StreamHandlerFacade _instance = null;

    private StreamHandlerFacade() {
    }

    public static synchronized StreamHandlerFacade getInstance() {
        if (_instance == null) {
            _instance = new StreamHandlerFacade();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createStream(String taskName, String fileExt, String droidId, String[] streamParams, Object[] params, String ruleType) throws DigitoolException {
        String newFileName;
        block8: {
            StreamHandlerUtil streamHandlerUtil = StreamHandlersMngr.getInstance().getHandler(taskName, droidId, fileExt, ruleType);
            newFileName = FileUtil.getFileName(streamParams[1]);
            if (streamHandlerUtil == null) {
                newFileName = FILE_NOT_MATCH;
            } else {
                log.info("Executing " + streamHandlerUtil.getClass().getName());
                String worker = StreamHandlersMngr.getInstance().getScriptWorker(streamHandlerUtil);
                try {
                    if (streamHandlerUtil.getWorkerType().equals((Object)StreamHandlerUtil.WorkerType.JAVA_CLASS)) {
                        StreamHandler streamHandler = StreamHandlersMngr.getInstance().getStreamHandler(streamHandlerUtil);
                        streamHandler.setParams(streamParams);
                        streamHandler.handleStream();
                        break block8;
                    }
                    Object[] workerParams = this.mergeParams(streamParams, params);
                    String txt = new ExternalProcessUtil().execWorker(worker, streamHandlerUtil.getParamsPattern(), workerParams);
                }
                catch (FailedToHandlerStreamException e) {
                    throw new DigitoolException(DescriptorConstants.IN_UnableToCreateStreamHandler, (Object)worker, (Object)e.getCause(), e.getMessage());
                }
                catch (Exception e) {
                    throw new DigitoolException(DescriptorConstants.IN_UnableToCreateStreamHandler, (Object)worker, e.getCause(), e.getClass());
                }
            }
        }
        return newFileName;
    }

    private Object[] mergeParams(Object[] p1, Object[] p2) {
        Object[] params = new Object[p1.length + p2.length];
        System.arraycopy(p1, 0, params, 0, p1.length);
        System.arraycopy(p2, 0, params, p1.length, p2.length);
        return params;
    }
}

