/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.sds;

import com.exlibris.core.infra.common.exceptions.InfraException;
import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.digitool.exceptions.DigitoolException;
import com.exlibris.digitool.repository.system.RpException;
import com.exlibris.digitool.sds.LegacyClient;
import com.exlibris.digitool.sds.LegacyClientMng;
import com.exlibris.digitool.sds.LegacyLibraryTypeEnum;
import com.exlibris.digitool.sds.LegacyResult;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.List;

public class SdsConnector {
    private static String m_sessionHandle = "init";
    private static long m_timer;
    private static final ExLogger logger;

    public LegacyResult approveAsDepositor(String id, String adm, boolean approve) throws DigitoolException {
        LegacyResult ret = null;
        LegacyClient lc = null;
        try {
            this.checkSessionValid();
            lc = LegacyClientMng.getLegacyClient();
            if (approve) {
                lc.setOperation("bor-dep-reg");
            } else {
                lc.setOperation("bor-dep-unreg");
            }
            lc.setId(id);
            lc.setUnit(adm);
            lc.setHandle(this.getSessionHandle());
            ret = lc.connectToLegacy();
        }
        catch (MalformedURLException e) {
            logger.error(DescriptorConstants.DP_UrlProblemConnectingToLegacy, (Object)m_sessionHandle, (Object)"bor-dep-reg", (Object)e.getMessage());
            throw new DigitoolException(DescriptorConstants.DP_UrlProblemConnectingToLegacy, (Object)m_sessionHandle, (Object)"bor-dep-reg", e.getMessage());
        }
        catch (IOException e) {
            logger.error(DescriptorConstants.DP_StreamReadingErrorFromLegacy, (Object)lc.getUrl());
            throw new DigitoolException(DescriptorConstants.DP_StreamReadingErrorFromLegacy, lc.getUrl());
        }
        catch (RpException e) {
            throw new DigitoolException(DescriptorConstants.DP_ErrorReadingFromConfig);
        }
        catch (InfraException e) {
            throw new DigitoolException(DescriptorConstants.DP_ErrorReadingFromConfig);
        }
        return ret;
    }

    public LegacyResult getStaffList() throws DigitoolException {
        LegacyResult ret = null;
        LegacyClient lc = null;
        try {
            this.checkSessionValid();
            lc = LegacyClientMng.getLegacyClient();
            lc.setOperation("staff-list");
            lc.setStartName("");
            lc.setEndName("ZZZZZZZZZZ");
            lc.setHandle(this.getSessionHandle());
            ret = lc.connectToLegacy();
        }
        catch (MalformedURLException e) {
            logger.error(DescriptorConstants.DP_UrlProblemConnectingToLegacy, (Object)m_sessionHandle, (Object)"staff-list", (Object)e.getMessage());
            throw new DigitoolException(DescriptorConstants.DP_UrlProblemConnectingToLegacy, (Object)m_sessionHandle, (Object)"staff-list", e.getMessage());
        }
        catch (IOException e) {
            logger.error(DescriptorConstants.DP_StreamReadingErrorFromLegacy, (Object)lc.getUrl());
            throw new DigitoolException(DescriptorConstants.DP_StreamReadingErrorFromLegacy, lc.getUrl());
        }
        catch (RpException e) {
            throw new DigitoolException(DescriptorConstants.DP_ErrorReadingFromConfig);
        }
        catch (InfraException e) {
            throw new DigitoolException(DescriptorConstants.DP_ErrorReadingFromConfig);
        }
        return ret;
    }

    public LegacyResult authenticateStaff(String staffName, String staffPassword) throws DigitoolException {
        LegacyResult ret = null;
        LegacyClient lc = null;
        try {
            this.checkSessionValid();
            lc = LegacyClientMng.getLegacyClient();
            lc.setOperation("staff-auth");
            lc.setStaffName(staffName);
            lc.setStaffPassword(staffPassword);
            lc.setHandle(this.getSessionHandle());
            ret = lc.connectToLegacy();
        }
        catch (MalformedURLException e) {
            logger.error(DescriptorConstants.DP_UrlProblemConnectingToLegacy, (Object)m_sessionHandle, (Object)"staff-list", (Object)e.getMessage());
            throw new DigitoolException(DescriptorConstants.DP_UrlProblemConnectingToLegacy, (Object)m_sessionHandle, "staff-list");
        }
        catch (IOException e) {
            logger.error(DescriptorConstants.DP_StreamReadingErrorFromLegacy, (Object)lc.getUrl());
            throw new DigitoolException(DescriptorConstants.DP_StreamReadingErrorFromLegacy, lc.getUrl());
        }
        catch (RpException e) {
            throw new DigitoolException(DescriptorConstants.DP_ErrorReadingFromConfig);
        }
        catch (InfraException e) {
            throw new DigitoolException(DescriptorConstants.DP_ErrorReadingFromConfig);
        }
        return ret;
    }

    public LegacyResult getIngestAllowedStaff() throws DigitoolException {
        LegacyResult ret = null;
        LegacyClient lc = null;
        try {
            this.checkSessionValid();
            lc = LegacyClientMng.getLegacyClient();
            lc.setOperation("staff-list");
            lc.setFunction("ingest");
            lc.setSubFunc("main");
            lc.setStartName("");
            lc.setEndName("ZZZZZZZZZZ");
            lc.setHandle(this.getSessionHandle());
            ret = lc.connectToLegacy();
        }
        catch (MalformedURLException e) {
            logger.error(DescriptorConstants.DP_UrlProblemConnectingToLegacy, (Object)m_sessionHandle, (Object)"staff-list", (Object)e.getMessage());
            throw new DigitoolException(DescriptorConstants.DP_UrlProblemConnectingToLegacy, (Object)m_sessionHandle, (Object)"staff-list", e.getMessage());
        }
        catch (IOException e) {
            logger.error(DescriptorConstants.DP_StreamReadingErrorFromLegacy, (Object)lc.getUrl());
            throw new DigitoolException(DescriptorConstants.DP_StreamReadingErrorFromLegacy, lc.getUrl());
        }
        catch (RpException e) {
            throw new DigitoolException(DescriptorConstants.DP_ErrorReadingFromConfig);
        }
        catch (InfraException e) {
            throw new DigitoolException(DescriptorConstants.DP_ErrorReadingFromConfig);
        }
        return ret;
    }

    private LegacyResult get(String op, String function, String subFunction, String staff_name, String library) throws DigitoolException {
        LegacyResult ret = null;
        LegacyClient lc = null;
        try {
            this.checkSessionValid();
            lc = LegacyClientMng.getLegacyClient();
            lc.setOperation(op);
            lc.setStaffName(staff_name);
            lc.setFuncLibrary(library);
            lc.setFunction(function);
            lc.setSubFunc(subFunction);
            lc.setHandle(this.getSessionHandle());
            ret = lc.connectToLegacy();
        }
        catch (MalformedURLException e) {
            logger.error(DescriptorConstants.DP_UrlProblemConnectingToLegacy, (Object)m_sessionHandle, (Object)"staff-list", (Object)e.getMessage());
            throw new DigitoolException(DescriptorConstants.DP_UrlProblemConnectingToLegacy, (Object)m_sessionHandle, "staff-list");
        }
        catch (IOException e) {
            logger.error(DescriptorConstants.DP_StreamReadingErrorFromLegacy, (Object)lc.getUrl());
            throw new DigitoolException(DescriptorConstants.DP_StreamReadingErrorFromLegacy, lc.getUrl());
        }
        catch (RpException e) {
            throw new DigitoolException(DescriptorConstants.DP_ErrorReadingFromConfig);
        }
        catch (InfraException e) {
            throw new DigitoolException(DescriptorConstants.DP_ErrorReadingFromConfig);
        }
        return ret;
    }

    public LegacyResult authorizeStaff(String function, String subFunction, String staff_name, String library) throws DigitoolException {
        return this.get("staff-chk-perm", function, subFunction, staff_name, library);
    }

    public List getSiloLibraryList() throws DigitoolException {
        LegacyResult lr = this.getLibraryList(LegacyLibraryTypeEnum.SILO);
        return lr.getLibraryList();
    }

    public LegacyResult getLibraryList(LegacyLibraryTypeEnum type) throws DigitoolException {
        LegacyClient lc = null;
        LegacyResult ret = null;
        try {
            this.checkSessionValid();
            lc = LegacyClientMng.getLegacyClient();
            lc.setOperation("lib-list");
            lc.setType(type.toString());
            lc.setHandle(this.getSessionHandle());
            ret = lc.connectToLegacy();
        }
        catch (MalformedURLException e) {
            logger.error(DescriptorConstants.DP_UrlProblemConnectingToLegacy, (Object)m_sessionHandle, (Object)"staff-list", (Object)e.getMessage());
            throw new DigitoolException(DescriptorConstants.DP_UrlProblemConnectingToLegacy, (Object)m_sessionHandle, "staff-list");
        }
        catch (IOException e) {
            logger.error(DescriptorConstants.DP_StreamReadingErrorFromLegacy, (Object)lc.getUrl());
            throw new DigitoolException(DescriptorConstants.DP_StreamReadingErrorFromLegacy, lc.getUrl());
        }
        catch (RpException e) {
            throw new DigitoolException(DescriptorConstants.DP_ErrorReadingFromConfig);
        }
        catch (InfraException e) {
            throw new DigitoolException(DescriptorConstants.DP_ErrorReadingFromConfig);
        }
        return ret;
    }

    public LegacyResult getUserInfo(String staffName) throws DigitoolException {
        LegacyClient lc = null;
        LegacyResult ret = null;
        try {
            this.checkSessionValid();
            lc = LegacyClientMng.getLegacyClient();
            lc.setOperation("staff-info");
            lc.setStaffName(staffName);
            lc.setHandle(this.getSessionHandle());
            ret = lc.connectToLegacy();
        }
        catch (MalformedURLException e) {
            logger.error(DescriptorConstants.DP_UrlProblemConnectingToLegacy, (Object)m_sessionHandle, (Object)"staff-list", (Object)e.getMessage());
            throw new DigitoolException(DescriptorConstants.DP_UrlProblemConnectingToLegacy, (Object)m_sessionHandle, "staff-list");
        }
        catch (IOException e) {
            logger.error(DescriptorConstants.DP_StreamReadingErrorFromLegacy, (Object)lc.getUrl());
            throw new DigitoolException(DescriptorConstants.DP_StreamReadingErrorFromLegacy, lc.getUrl());
        }
        catch (RpException e) {
            throw new DigitoolException(DescriptorConstants.DP_ErrorReadingFromConfig);
        }
        catch (InfraException e) {
            throw new DigitoolException(DescriptorConstants.DP_ErrorReadingFromConfig);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSessionValid() throws MalformedURLException, IOException, InfraException {
        String string = m_sessionHandle;
        synchronized (string) {
            if (new Date().getTime() - m_timer > 1000000L) {
                new LegacyClient().initializeSuperSession();
                m_sessionHandle = LegacyClient.getSuperSessionHandle();
                m_timer = new Date().getTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSessionHandle() {
        String string = m_sessionHandle;
        synchronized (string) {
            if (m_sessionHandle == "init") {
                m_sessionHandle = "";
            }
            return m_sessionHandle;
        }
    }

    static {
        logger = ExLogger.getExLogger(SdsConnector.class);
    }
}

