/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.utils;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.sdk.strings.StringUtils;
import com.exlibris.core.sdk.utils.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVStrategy;
import org.apache.commons.csv.CSVUtils;
import org.apache.commons.lang.StringEscapeUtils;

public class CSVUtil {
    private static final ExLogger log = ExLogger.getExLogger(CSVUtil.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static List<String[]> readFile(File f, boolean hasHeaderRow) throws Exception {
        if (!f.exists()) {
            throw new FileNotFoundException("Unable to read file: " + f.getName());
        }
        log.info("Reading CSV file: " + f.getName());
        ArrayList<String[]> values = new ArrayList<String[]>();
        try {
            String[] lines;
            String content = FileUtil.getContents(f);
            if (hasHeaderRow) {
                content = content.substring(content.indexOf(LINE_SEPARATOR));
            }
            if (StringUtils.isEmptyString(content)) {
                throw new Exception("CSV file contains no content " + f.getName());
            }
            for (String line : lines = content.split(LINE_SEPARATOR)) {
                if (StringUtils.isEmptyString(line)) continue;
                try {
                    String[] parsedLine = CSVUtils.parseLine((String)line);
                    CSVUtil.unescapeValues(parsedLine);
                    values.add(parsedLine);
                }
                catch (Exception e) {
                    log.error("Unable to read CSV line: " + line, new String[0]);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Error occured while parsing CSV file " + f.getName() + "\nCause: " + e.toString());
        }
        log.info("Finished reading CSV file: " + f.getName());
        return values;
    }

    public static List<String[]> readFile(String filename, boolean hasHeaderRow) throws Exception {
        return CSVUtil.readFile(new File(filename), hasHeaderRow);
    }

    public static void writeFile(File f, List<String[]> values, String[] headerRow) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (headerRow != null) {
            sb.append(CSVUtil.getAsString(headerRow)).append(LINE_SEPARATOR);
        }
        if (values != null) {
            for (String[] row : values) {
                sb.append(CSVUtil.getAsString(row)).append(LINE_SEPARATOR);
            }
        }
        FileUtil.writeFile(f, sb.toString());
    }

    public static void appendFile(File f, List<String[]> values) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (String[] row : values) {
            sb.append(CSVUtil.getAsString(row)).append(LINE_SEPARATOR);
        }
        FileUtil.writeFile(f, sb.toString(), true);
    }

    public static void appendFile(String filename, List<String[]> values) throws Exception {
        CSVUtil.appendFile(new File(filename), values);
    }

    public static void appendStringFile(File f, List<String[]> values) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (String[] row : values) {
            sb.append(CSVUtil.getAsString(row)).append(LINE_SEPARATOR);
        }
        FileUtil.writeFile(f, sb.toString(), true);
    }

    public static void appendStringFile(String filename, List<String[]> values) throws Exception {
        CSVUtil.appendStringFile(new File(filename), values);
    }

    public static void writeFile(File f, List<String[]> values) throws Exception {
        CSVUtil.writeFile(f, values, null);
    }

    public static void writeFile(String filename, List<String[]> values, String[] headerRow) throws Exception {
        CSVUtil.writeFile(new File(filename), values, headerRow);
    }

    public static void writeFile(String filename, List<String[]> values) throws Exception {
        CSVUtil.writeFile(new File(filename), values, null);
    }

    public static String getAsString(String[] values) {
        if (values == null || values.length == 0) {
            return "";
        }
        CSVUtil.escapeValues(values);
        String line = CSVUtils.printLine((String[])values);
        line = CSVUtil.replaceNull(line);
        return line;
    }

    private static String replaceNull(String line) {
        line = line.replaceAll(CSVStrategy.DEFAULT_STRATEGY.getDelimiter() + "null", CSVStrategy.DEFAULT_STRATEGY.getDelimiter() + "");
        return line;
    }

    private static void escapeValues(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = StringEscapeUtils.escapeJava((String)values[i]);
        }
    }

    private static void unescapeValues(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = StringEscapeUtils.unescapeJava((String)values[i]);
        }
    }
}

