/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.utils;

import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.digitool.common.dnx.DnxDocumentHelper;
import com.exlibris.repository.persistence.digitalentity.HDeMetadataRegistry;
import com.exlibris.repository.persistence.digitalentity.HDeStreamRef;
import org.apache.commons.lang.StringUtils;

public class MetadataUtils {
    public static boolean isMdRelevantToObjectType(HDeMetadataRegistry mddao, Enum.ObjectType objectType) {
        boolean isRelevant = false;
        switch (objectType) {
            case INTELLECTUAL_ENTITY: {
                isRelevant = mddao.isRelevantToIE();
                break;
            }
            case REPRESENTATION: {
                isRelevant = mddao.isRelevantToRep();
                break;
            }
            case FILE: {
                isRelevant = mddao.isRelevantToFile();
                break;
            }
        }
        return isRelevant;
    }

    public static String getFileName(HDeStreamRef stream, DnxDocumentHelper.GeneralFileCharacteristics generalFileCharacteristics) {
        String originalFileName = stream.getFileName();
        if (StringUtils.isBlank((String)originalFileName)) {
            originalFileName = generalFileCharacteristics.getFileOriginalName();
        }
        if (StringUtils.isBlank((String)originalFileName)) {
            originalFileName = stream.getPid() + "." + stream.getFileExtension();
        }
        return originalFileName;
    }
}

