/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.persistence.storage;

import com.exlibris.core.sdk.strings.StringUtils;
import com.exlibris.repository.persistence.HPersistent;
import javax.persistence.Column;
import javax.persistence.Entity;

@Entity
public class HReStorageRule
extends HPersistent {
    private long appId;
    private long ruleOrder;
    private String application;
    private String owner;
    private String preservationLevel;
    private long moreThanKB;
    private String mimeType;
    private String fileExt;
    private long storageGroupAppId;

    public HReStorageRule() {
    }

    @Column(nullable=false, unique=true, name="appId")
    public long getAppId() {
        return this.appId;
    }

    public void setAppId(long appId) {
        this.appId = appId;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getFileExt() {
        return this.fileExt;
    }

    public void setFileExt(String fileExt) {
        this.fileExt = fileExt;
        this.fileExt = this.fileExt.replaceAll(",", " ");
        this.fileExt = this.fileExt.replaceAll("\\.", " ");
        this.fileExt = StringUtils.pack_blanks(this.fileExt);
        this.fileExt = this.fileExt.toLowerCase().trim();
        this.fileExt = this.fileExt.replaceAll(" ", ",");
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
        this.mimeType = this.mimeType.replaceAll(",", " ");
        this.mimeType = this.mimeType.replaceAll("\\.", " ");
        this.mimeType = StringUtils.pack_blanks(this.mimeType);
        this.mimeType = this.mimeType.toLowerCase().trim();
        this.mimeType = this.mimeType.replaceAll(" ", ",");
    }

    public long getMoreThanKB() {
        return this.moreThanKB;
    }

    public void setMoreThanKB(long moreThanKB) {
        this.moreThanKB = moreThanKB;
    }

    public String getPreservationLevel() {
        return this.preservationLevel;
    }

    public void setPreservationLevel(String preservationLevel) {
        this.preservationLevel = preservationLevel;
        this.preservationLevel = this.preservationLevel.toLowerCase().trim();
    }

    @Column(nullable=false)
    public long getStorageGroupAppId() {
        return this.storageGroupAppId;
    }

    public void setStorageGroupAppId(long storageGroupAppId) {
        this.storageGroupAppId = storageGroupAppId;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Column(nullable=false)
    public long getRuleOrder() {
        return this.ruleOrder;
    }

    public void setRuleOrder(long ruleOrder) {
        this.ruleOrder = ruleOrder;
    }

    public HReStorageRule(long appId, long ruleOrder, String application, String owner, String preservationLevel, long moreThanKB, String mimeType, String fileExt, long storageGroupAppId) {
        this.appId = appId;
        this.ruleOrder = ruleOrder;
        this.application = application;
        this.owner = owner;
        this.preservationLevel = preservationLevel;
        this.moreThanKB = moreThanKB;
        this.mimeType = mimeType;
        this.fileExt = fileExt;
        this.storageGroupAppId = storageGroupAppId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.appId ^ this.appId >>> 32);
        result = 31 * result + (this.application == null ? 0 : this.application.hashCode());
        result = 31 * result + (this.fileExt == null ? 0 : this.fileExt.hashCode());
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        result = 31 * result + (int)(this.moreThanKB ^ this.moreThanKB >>> 32);
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.preservationLevel == null ? 0 : this.preservationLevel.hashCode());
        result = 31 * result + (int)(this.ruleOrder ^ this.ruleOrder >>> 32);
        result = 31 * result + (int)(this.storageGroupAppId ^ this.storageGroupAppId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HReStorageRule other = (HReStorageRule)obj;
        if (this.appId != other.appId) {
            return false;
        }
        if (this.application == null ? other.application != null : !this.application.equals(other.application)) {
            return false;
        }
        if (this.fileExt == null ? other.fileExt != null : !this.fileExt.equals(other.fileExt)) {
            return false;
        }
        if (this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType)) {
            return false;
        }
        if (this.moreThanKB != other.moreThanKB) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        if (this.preservationLevel == null ? other.preservationLevel != null : !this.preservationLevel.equals(other.preservationLevel)) {
            return false;
        }
        if (this.ruleOrder != other.ruleOrder) {
            return false;
        }
        return this.storageGroupAppId == other.storageGroupAppId;
    }
}

