/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.procauto;

import com.exlibris.repository.persistence.HDeSet;
import com.exlibris.repository.procauto.HPaProcessExecution;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;

@Entity
@NamedQueries(value={@NamedQuery(name="getNumberOfFinishedBulks", query="select count(*) from HPaProcessExecutionBulk as hpe where hpe.processExecution.processExecutionId = :processExecutionId AND status <> :status"), @NamedQuery(name="getNumberOfBulksForExecutionByStatus", query="select hpe from HPaProcessExecutionBulk as hpe where hpe.processExecution.processExecutionId = :processExecutionId AND status = :status"), @NamedQuery(name="findNextBulkByProcExecutionId", query="SELECT hpe from HPaProcessExecutionBulk as hpe WHERE hpe.status=:status AND hpe.processExecution.processExecutionId = :processExecutionId AND ROWNUM<:bulkrowstofetch"), @NamedQuery(name="getRunningBulksWithOldStatus", query="SELECT hpe from HPaProcessExecutionBulk as hpe WHERE hpe.processExecution.status=:executionStatus AND hpe.status=:status AND hpe.statusDate < (SYSDATE - :numberOfInactiveMin/1440)"), @NamedQuery(name="setBulkStatus", query="UPDATE HPaProcessExecutionBulk as hpe SET hpe.status = :status WHERE hpe.bulkId = :bulkId")})
@Table(name="HPAPROCESSEXECUTIONBULK")
@SequenceGenerator(name="bulkidseq", sequenceName="BULK_ID_SEQ")
public class HPaProcessExecutionBulk {
    @Transient
    public static final String TABLE_NAME = "HPAPROCESSEXECUTIONBULK";
    public static final String PID_DELIMITER = ",";
    private HPaProcessExecution processExecution;
    private Long bulkId;
    private BulkExecutionStatus status;
    private Date statusDate;
    private String pids;
    private String lastItem;
    private Long lastTask;
    private Long bulkSize;
    private Long totalSuccessItemCount;
    private Long totalItemsToCommitCount;
    private Long totalErrorItemCount;
    private Long doneItemCount;
    private String workerApplicationId;
    private Long numberOfRetry;
    private HDeSet.PremisObjectType setLevel;

    @Id
    @Column(name="BULK_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="bulkidseq")
    public Long getBulkId() {
        return this.bulkId;
    }

    public void setBulkId(Long bulkId) {
        this.bulkId = bulkId;
    }

    @ManyToOne
    @JoinColumn(name="PROCESS_EXECUTION_ID", referencedColumnName="PROCESS_EXECUTION_ID", nullable=false)
    public HPaProcessExecution getProcessExecution() {
        return this.processExecution;
    }

    public void setProcessExecution(HPaProcessExecution processExecution) {
        this.processExecution = processExecution;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="STATUS", nullable=false)
    @Index(name="BULK_STATUS_IDX")
    public BulkExecutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(BulkExecutionStatus status) {
        this.status = status;
    }

    @Column(name="STATUS_DATE", columnDefinition="Date default SYSDATE")
    public Date getStatusDate() {
        return this.statusDate;
    }

    public void setStatusDate(Date statusDate) {
        this.statusDate = statusDate;
    }

    @Lob
    @Column(name="PID_LIST", nullable=false)
    public String getPids() {
        return this.pids;
    }

    public void setPids(String pids) {
        this.pids = pids;
    }

    @Column(name="LAST_ITEM", length=30)
    public String getLastItem() {
        return this.lastItem;
    }

    public void setLastItem(String lastItem) {
        this.lastItem = lastItem;
    }

    @Column(name="LAST_TASK", length=30)
    public Long getLastTask() {
        return this.lastTask;
    }

    public void setLastTask(Long lastTask) {
        this.lastTask = lastTask;
    }

    @Column(name="BULK_SIZE")
    public Long getBulkSize() {
        return this.bulkSize;
    }

    public void setBulkSize(Long bulkSize) {
        this.bulkSize = bulkSize;
    }

    @Column(name="TOTAL_SUCCESS_ITEM_COUNT")
    public Long getTotalSuccessItemsCount() {
        return this.totalSuccessItemCount;
    }

    public void setTotalSuccessItemsCount(Long totalSuccessItemsCount) {
        this.totalSuccessItemCount = totalSuccessItemsCount;
    }

    @Column(name="TOTAL_ITEMS_TO_COMMIT_COUNT")
    public Long getTotalItemsToCommitCount() {
        return this.totalItemsToCommitCount;
    }

    public void setTotalItemsToCommitCount(Long totalItemsToCommitCount) {
        this.totalItemsToCommitCount = totalItemsToCommitCount;
    }

    @Column(name="TOTAL_ERROR_ITEM_COUNT")
    public Long getTotalErrorItemsCount() {
        if (this.totalErrorItemCount == null) {
            this.totalErrorItemCount = 0L;
        }
        return this.totalErrorItemCount;
    }

    public void setTotalErrorItemsCount(Long totalErrorItemsCount) {
        this.totalErrorItemCount = totalErrorItemsCount;
    }

    @Column(name="DONE_ITEM_COUNT")
    public Long getDoneItemCount() {
        return this.doneItemCount;
    }

    public void setDoneItemCount(Long doneItemCount) {
        this.doneItemCount = doneItemCount;
    }

    @Column(name="WORKER_APPLICATION_ID", length=100)
    public String getWorkerApplicationId() {
        return this.workerApplicationId;
    }

    public void setWorkerApplicationId(String workerApplicationId) {
        this.workerApplicationId = workerApplicationId;
    }

    @Column(name="NUM_OF_RETRY")
    public Long getNumberOfRetry() {
        return this.numberOfRetry;
    }

    public void setNumberOfRetry(Long numberOfRetry) {
        this.numberOfRetry = numberOfRetry;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="SET_LEVEL", nullable=false)
    public HDeSet.PremisObjectType getSetLevel() {
        return this.setLevel;
    }

    public void setSetLevel(HDeSet.PremisObjectType setLevel) {
        this.setLevel = setLevel;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bulkId == null ? 0 : this.bulkId.hashCode());
        result = 31 * result + (this.workerApplicationId == null ? 0 : this.workerApplicationId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HPaProcessExecutionBulk)) {
            return false;
        }
        HPaProcessExecutionBulk other = (HPaProcessExecutionBulk)obj;
        if (this.bulkId == null ? other.bulkId != null : !this.bulkId.equals(other.bulkId)) {
            return false;
        }
        return !(this.workerApplicationId == null ? other.workerApplicationId != null : !this.workerApplicationId.equals(other.workerApplicationId));
    }

    public static enum BulkExecutionStatus {
        INITIALIZING,
        PENDING,
        IN_PROGRESS,
        DONE_PROCESSING,
        ABORTED;


        public static BulkExecutionStatus valueOfInt(int decimal) {
            BulkExecutionStatus[] statuss;
            for (BulkExecutionStatus bulkExecutionStatus : statuss = BulkExecutionStatus.values()) {
                if (decimal != bulkExecutionStatus.ordinal()) continue;
                return bulkExecutionStatus;
            }
            return null;
        }
    }
}

