/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.procauto;

import com.exlibris.core.infra.model.DividedDate;
import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.repository.procauto.HPaGroup;
import com.exlibris.repository.procauto.HPaProcess;
import com.exlibris.repository.procauto.HPaTask;
import com.exlibris.repository.procauto.HPaTaskChainTasks;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;

@Entity
@NamedQueries(value={@NamedQuery(name="findTaskChainsByGroupId", query="SELECT tch from HPaTaskChain tch JOIN tch.taskGroup p WHERE p.groupId=:groupId and tch.status<:status"), @NamedQuery(name="findActiveTaskChainsByGroupId", query="SELECT tch from HPaTaskChain tch JOIN tch.taskGroup p WHERE p.groupId=:groupId and tch.status=:status"), @NamedQuery(name="findTaskChainsBySystemId", query="SELECT tch from HPaTaskChain tch WHERE tch.systemId=:systemId"), @NamedQuery(name="findTaskChainsByGroupAndLevel", query="SELECT tch from HPaTaskChain tch JOIN tch.taskGroup p WHERE p.groupId=:groupId and tch.status=:status and tch.level in (:level)")})
@Table(name="HPATASKCHAIN")
public class HPaTaskChain {
    private Long taskChainId;
    private String name;
    private String description;
    private String createdBy;
    private Date creationDate;
    private String modifiedBy;
    private Date modificationDate;
    private TaskChainStatus status;
    private String taskChainStatus;
    private Date statusDate;
    private DividedDate statusDateDummy;
    private TaskChainLogLevel logLevel;
    private String taskChainLogLevel;
    private TaskChainLogSensitivity logSensitivity;
    private String taskChainLogSensitivity;
    private String evaluatorClass;
    private String systemId;
    private TaskChainLevel level;
    private List<HPaProcess> process;
    private List<HPaTaskChainTasks> taskChainTask;
    private List<HPaGroup> taskGroup;
    private String indexXml;

    public HPaTaskChain() {
    }

    public HPaTaskChain(Long taskChainId, String name, String description, String createdBy, Date creationDate, String modifiedBy, Date modificationDate, TaskChainStatus status, Date statusDate, TaskChainLogLevel logLevel, TaskChainLogSensitivity logSensitivity, String evaluatorClass, String systemId, TaskChainLevel level) {
        this.taskChainId = taskChainId;
        this.name = name;
        this.description = description;
        this.createdBy = createdBy;
        this.creationDate = creationDate;
        this.modifiedBy = modifiedBy;
        this.modificationDate = modificationDate;
        this.status = status;
        this.taskChainStatus = status.name();
        this.statusDate = statusDate;
        this.logLevel = logLevel;
        this.taskChainLogLevel = logLevel.name();
        this.logSensitivity = logSensitivity;
        this.taskChainLogSensitivity = logSensitivity.name();
        this.evaluatorClass = evaluatorClass;
        this.systemId = systemId;
        this.level = level;
    }

    @Id
    @Column(name="TASK_CHAIN_ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getTaskChainId() {
        return this.taskChainId;
    }

    public void setTaskChainId(Long taskChainId) {
        this.taskChainId = taskChainId;
    }

    @OneToMany(mappedBy="taskChain")
    public List<HPaProcess> getProcess() {
        return this.process;
    }

    @ManyToMany(mappedBy="taskChains", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @OrderBy(value="groupId")
    public List<HPaGroup> getTaskGroup() {
        return this.taskGroup;
    }

    public void setTaskGroup(List<HPaGroup> taskChainGroup) {
        this.taskGroup = taskChainGroup;
    }

    public void addGroup(HPaGroup group) {
        if (this.getTaskGroup() == null) {
            this.setTaskGroup(new ArrayList<HPaGroup>(0));
        }
        this.getTaskGroup().add(group);
        group.addTaskChain(this);
    }

    public void removeGroup(HPaGroup group) {
        if (this.getTaskGroup() == null || group == null) {
            return;
        }
        this.getTaskGroup().remove(group);
        group.removeTaskChain(this);
    }

    public void setProcess(List<HPaProcess> processList) {
        this.process = processList;
    }

    @Column(name="NAME", length=50)
    @Searchable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="DESCRIPTION", length=1000)
    @Searchable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="CREATED_BY")
    @Searchable
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Column(name="CREATION_DATE", nullable=false)
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Column(name="MODIFIED_BY", length=50)
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @Column(name="MODIFIED_DATE")
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="STATUS", nullable=false)
    public TaskChainStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskChainStatus status) {
        this.status = status;
    }

    @Transient
    public String getTaskChainStatus() {
        return this.status.name();
    }

    public void setTaskChainStatus(String taskChainStatus) {
        this.status = TaskChainStatus.valueOf(taskChainStatus);
        this.taskChainStatus = taskChainStatus;
    }

    @Column(name="STATUS_DATE")
    public Date getStatusDate() {
        return this.statusDate;
    }

    public void setStatusDate(Date statusDate) {
        this.statusDate = statusDate;
        Calendar instance = Calendar.getInstance();
        if (this.statusDate != null) {
            instance.setTime(this.statusDate);
            this.statusDateDummy = new DividedDate(instance);
        } else {
            this.statusDate = instance.getTime();
        }
    }

    @Transient
    public DividedDate getStatusDateDummy() {
        if (this.statusDateDummy == null) {
            Calendar instance = null;
            instance = Calendar.getInstance();
            if (this.statusDate != null) {
                instance.setTime(this.statusDate);
            }
            this.statusDateDummy = new DividedDate(instance);
        }
        return this.statusDateDummy;
    }

    public void setStatusDateDummy(DividedDate statusDateDummy) {
        this.statusDateDummy = statusDateDummy;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="LOG_LEVEL", nullable=false, length=50)
    public TaskChainLogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(TaskChainLogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Transient
    public String getTaskChainLogLevel() {
        return this.logLevel.name();
    }

    public void setTaskChainLogLevel(String taskChainLogLevel) {
        this.logLevel = TaskChainLogLevel.valueOf(taskChainLogLevel);
        this.taskChainLogLevel = taskChainLogLevel;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="LOG_SENSITIVITY", nullable=false)
    public TaskChainLogSensitivity getLogSensitivity() {
        return this.logSensitivity;
    }

    public void setLogSensitivity(TaskChainLogSensitivity logSensitivity) {
        this.logSensitivity = logSensitivity;
    }

    @Transient
    public String getTaskChainLogSensitivity() {
        return this.logSensitivity.name();
    }

    public void setTaskChainLogSensitivity(String taskChainLogSensitivity) {
        this.logSensitivity = TaskChainLogSensitivity.valueOf(taskChainLogSensitivity);
        this.taskChainLogSensitivity = taskChainLogSensitivity;
    }

    @Column(name="EVALUATOR_CLASS", nullable=false)
    public String getEvaluatorClass() {
        return this.evaluatorClass;
    }

    public void setEvaluatorClass(String evaluatorClass) {
        this.evaluatorClass = evaluatorClass;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="TASK_CHAIN_ID", updatable=false)
    @OrderBy(value="taskOrder asc")
    public List<HPaTaskChainTasks> getTaskChainTask() {
        return this.taskChainTask;
    }

    public void setTaskChainTask(List<HPaTaskChainTasks> taskChainTask) {
        this.taskChainTask = taskChainTask;
    }

    public HPaTaskChainTasks addTask(HPaTask task, String parameters) {
        if (this.getTaskChainTask() == null) {
            this.setTaskChainTask(new ArrayList<HPaTaskChainTasks>(0));
        }
        HPaTaskChainTasks taskChainTasks = new HPaTaskChainTasks();
        taskChainTasks.setHPaTaskChain(this);
        taskChainTasks.setParameters(parameters);
        taskChainTasks.setHPaTask(task);
        task.addTaskChainTasks(taskChainTasks);
        return taskChainTasks;
    }

    @Column(name="SYSTEM_ID", length=250)
    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="TASK_CHAIN_LEVEL", nullable=false)
    public TaskChainLevel getLevel() {
        return this.level;
    }

    public void setLevel(TaskChainLevel level) {
        this.level = level;
    }

    @Transient
    public String getTaskChainLevel() {
        return this.level.name();
    }

    public void setTaskChainLevel(String taskChainLevel) {
        this.level = TaskChainLevel.valueOf(taskChainLevel);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.taskChainId == null ? 0 : this.taskChainId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HPaTaskChain)) {
            return false;
        }
        HPaTaskChain other = (HPaTaskChain)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.taskChainId == null ? other.taskChainId != null : !this.taskChainId.equals(other.taskChainId));
    }

    @Column(name="index_xml")
    @Lob
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    public static enum TaskChainGroup {
        VALIDATION_STACK(1L),
        ENRICHMENT(2L),
        MD_VALIDATION(3L),
        MTP(4L),
        MAINTENANCE(5L),
        WORKBENCH(6L),
        WEBEDITOR_STAGING(7L),
        WEBEDITOR_PERMANENT(8L),
        SYSTEM(9L),
        PRESERVATION(10L);

        private Long taskChainGroupId;

        private TaskChainGroup(Long num) {
            this.taskChainGroupId = num;
        }

        public Long getTaskChainGroupId() {
            return this.taskChainGroupId;
        }
    }

    public static enum TaskChainLevel {
        INTELLECTUAL_ENTITY,
        REPRESENTATION,
        FILE;

    }

    public static enum TaskChainLogSensitivity {
        EXCEPTION,
        ALL;

    }

    public static enum TaskChainLogLevel {
        TASKCHAIN,
        TASK;

    }

    public static enum TaskChainStatus {
        ACTIVE,
        INACTIVE,
        DELETED,
        HIDDEN;

    }
}

