/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.xml;

import java.lang.reflect.Method;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.gov.nationalarchives.droid.core.signature.FileFormat;
import uk.gov.nationalarchives.droid.core.signature.droid6.FFSignatureFile;
import uk.gov.nationalarchives.droid.core.signature.xml.SimpleElement;

public class SAXModelBuilder
extends DefaultHandler {
    private static final String ADD = "add";
    private static final String SET = "set";
    private Log log = LogFactory.getLog(this.getClass());
    private Stack<Object> stack = new Stack();
    private SimpleElement element;
    private String mySignaturePackage = FFSignatureFile.class.getPackage().getName();
    private String myFormatPackage = FileFormat.class.getPackage().getName();
    private String namespace = "";
    private boolean useNamespace;
    private boolean allowGlobalNamespace = true;

    public void setSignaturePackage(String theSignaturePackage) {
        this.mySignaturePackage = theSignaturePackage;
    }

    public void setupNamespace(String nspace, boolean globalNamespace) {
        if (nspace == null) {
            throw new IllegalArgumentException("Namespace cannot be null");
        }
        this.namespace = nspace;
        this.useNamespace = true;
        this.allowGlobalNamespace = globalNamespace;
    }

    private String handleNameNS(String nspace, String localname, String qname) {
        String result = null;
        if (this.useNamespace && this.namespace.equals(nspace)) {
            result = localname;
        } else if (this.allowGlobalNamespace && "".equals(nspace)) {
            result = qname;
        }
        return result;
    }

    @Override
    public void startElement(String nspace, String localname, String qname, Attributes atts) {
        String elementName = this.handleNameNS(nspace, localname, qname);
        if (elementName == null) {
            return;
        }
        SimpleElement elem = null;
        String packName = "FileFormat".equals(elementName) || "FileFormatHit".equals(elementName) || "FileFormatCollection".equals(elementName) ? this.myFormatPackage : this.mySignaturePackage;
        String fullName = packName + "." + elementName;
        try {
            elem = (SimpleElement)Class.forName(fullName).newInstance();
        }
        catch (Exception e) {
            this.log.debug((Object)("No class exists for element name:" + elementName));
        }
        if (elem == null) {
            elem = new SimpleElement();
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            String attributeName = this.handleNameNS(atts.getURI(i), atts.getLocalName(i), atts.getQName(i));
            if (attributeName == null) continue;
            elem.setAttributeValue(attributeName, atts.getValue(i));
        }
        this.stack.push(elem);
    }

    @Override
    public void endElement(String nspace, String localname, String qname) throws SAXException {
        String elementName = this.handleNameNS(nspace, localname, qname);
        if (elementName == null) {
            return;
        }
        this.element = (SimpleElement)this.stack.pop();
        this.element.completeElementContent();
        if (!this.stack.empty()) {
            try {
                this.setProperty(elementName, this.stack.peek(), this.element);
            }
            catch (SAXException e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int len) {
        if (!this.stack.empty()) {
            String text = new String(ch, start, len);
            ((SimpleElement)this.stack.peek()).setText(text);
        }
    }

    void setProperty(String name, Object target, Object value) throws SAXException {
        Method method = null;
        Object val = value;
        try {
            method = target.getClass().getMethod(ADD + name, val.getClass());
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = target.getClass().getMethod(SET + name, val.getClass());
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (method == null) {
            try {
                val = ((SimpleElement)val).getText().trim();
                method = target.getClass().getMethod(ADD + name, String.class);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        try {
            if (method == null) {
                method = target.getClass().getMethod(SET + name, String.class);
            }
            method.invoke(target, val);
        }
        catch (NoSuchMethodException e) {
            this.unknownElementWarning(name, ((SimpleElement)target).getElementName());
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public SimpleElement getModel() {
        return this.element;
    }

    public void unknownElementWarning(String unknownElement, String containerElement) {
        String warning = "WARNING: Unknown XML element " + unknownElement + " found under " + containerElement + " ";
        this.log.debug((Object)warning);
    }
}

