/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.action;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.action.DroidCommand;
import uk.gov.nationalarchives.droid.command.filter.CommandLineFilter;
import uk.gov.nationalarchives.droid.command.filter.DqlFilterParser;
import uk.gov.nationalarchives.droid.command.filter.SimpleFilter;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.export.interfaces.ExportManager;
import uk.gov.nationalarchives.droid.export.interfaces.ExportOptions;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileManager;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;

public class ExportCommand
implements DroidCommand {
    private String[] profiles;
    private ExportManager exportManager;
    private ProfileManager profileManager;
    private DqlFilterParser dqlFilterParser;
    private String destination;
    private CommandLineFilter cliFilter;
    private ExportOptions options;

    @Override
    public void execute() throws CommandExecutionException {
        ArrayList<String> profileIds = new ArrayList<String>();
        SimpleFilter filter = null;
        if (this.cliFilter != null) {
            filter = new SimpleFilter(this.cliFilter.getFilterType());
            for (String dql : this.cliFilter.getFilters()) {
                filter.add(this.dqlFilterParser.parse(dql));
            }
        }
        for (String profileLocation : this.profiles) {
            try {
                ProfileInstance profile = this.profileManager.open(new File(profileLocation), new ProgressObserver(){

                    public void onProgress(Integer progress) {
                    }
                });
                profileIds.add(profile.getUuid());
            }
            catch (IOException e) {
                throw new CommandExecutionException(e);
            }
        }
        try {
            this.exportManager.exportProfiles(profileIds, this.destination, (Filter)filter, this.options).get();
        }
        catch (InterruptedException e) {
            throw new CommandExecutionException(e);
        }
        catch (ExecutionException e) {
            throw new CommandExecutionException(e.getCause());
        }
        finally {
            for (String profileId : profileIds) {
                this.profileManager.closeProfile(profileId);
            }
        }
    }

    public void setProfiles(String[] profileList) {
        this.profiles = profileList;
    }

    public void setExportManager(ExportManager exportManager) {
        this.exportManager = exportManager;
    }

    String[] getProfiles() {
        return this.profiles;
    }

    public ExportOptions getExportOptions() {
        return this.options;
    }

    public void setExportOptions(ExportOptions opt) {
        this.options = opt;
    }

    public void setProfileManager(ProfileManager profileManager) {
        this.profileManager = profileManager;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    String getDestination() {
        return this.destination;
    }

    public void setFilter(CommandLineFilter filter) {
        this.cliFilter = filter;
    }

    public void setDqlFilterParser(DqlFilterParser dqlFilterParser) {
        this.dqlFilterParser = dqlFilterParser;
    }
}

