/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.action;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.action.DroidCommand;
import uk.gov.nationalarchives.droid.command.i18n.I18N;
import uk.gov.nationalarchives.droid.report.interfaces.ReportManager;
import uk.gov.nationalarchives.droid.report.interfaces.ReportSpec;

public class ListReportsCommand
implements DroidCommand {
    private PrintWriter printWriter;
    private ReportManager reportManager;

    @Override
    public void execute() throws CommandExecutionException {
        List reports = this.reportManager.listReportSpecs();
        if (reports.isEmpty()) {
            this.printWriter.println(I18N.getResource("reports.none"));
        } else {
            StringBuilder builder = new StringBuilder();
            for (ReportSpec report : reports) {
                String reportDescription = String.format("\nReport:\t'%s'\n\tFormats:", report.getName());
                builder.append(reportDescription);
                List<String> outputFormats = this.getReportOutputFormats(report);
                for (String format : outputFormats) {
                    builder.append("\t'");
                    builder.append(format);
                    builder.append("'");
                }
                builder.append("\t'Pdf'\t'DROID Report XML'");
                this.printWriter.println(builder.toString());
            }
        }
    }

    private List<String> getReportOutputFormats(ReportSpec report) {
        ArrayList<String> outputFormats = new ArrayList<String>();
        List xslFiles = report.getXslTransforms();
        for (File xslFile : xslFiles) {
            String baseName = FilenameUtils.getBaseName((String)xslFile.getName());
            int stop = baseName.indexOf(46);
            if (stop <= -1) continue;
            String description = baseName.substring(0, stop);
            outputFormats.add(description);
        }
        return outputFormats;
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    public void setReportManager(ReportManager reportManager) {
        this.reportManager = reportManager;
    }
}

