/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.exception;


import java.util.List;


/**
 * This Exception is used to signal that at least one <a href="./Exception.html">Exception</a> is present in the <a href="./ExceptionCollector.html">ExceptionCollector</a>.
 * @author denis
 *
 */
@SuppressWarnings("serial")
public class ExceptionCollectorException extends java.lang.Exception
{

	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	private List<Exception>			exceptions;


	public ExceptionCollectorException()
	{
		this.exceptions = ExceptionCollector.getAll();
		ExceptionCollector.clear();
	}

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Instance Public			=======================================================

	//	--------		Accessing			-------------------------------------------------------

	public List<Exception> getAllExceptions()
	{
		return this.exceptions;
	}


	@Override
	public String getMessage()
	{
		StringBuilder message = new StringBuilder();
		for (Exception x: this.exceptions)		message.append("\n").append(x.toString());

		return message.toString();
	}

	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

}
