/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.file;


import java.io.File;

/**
 * @author lem
 *
 */
public abstract class FileFilter extends javax.swing.filechooser.FileFilter implements java.io.FileFilter, java.io.FilenameFilter
{
	static public FileFilter	VisibleAll = new FileFilter()
	{
		/*
		 * (non-Javadoc)
		 *
		 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
		 */
		@Override
		public boolean accept(File f)
		{
			return !(f.isHidden() || f.getName().startsWith("."));
		}

		/* (non-Javadoc)
		 * @see javax.swing.filechooser.FileFilter#getDescription()
		 */
		@Override
		public String getDescription()
		{
			return "All visible files and directories";
		}
	};


	static public FileFilter	VisibleFiles = new FileFilter()
	{
		/*
		 * (non-Javadoc)
		 *
		 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
		 */
		@Override
		public boolean accept(File f)
		{
			return f.isFile() && !(f.isHidden() || f.getName().startsWith("."));
		}

		/* (non-Javadoc)
		 * @see javax.swing.filechooser.FileFilter#getDescription()
		 */
		@Override
		public String getDescription()
		{
			return "All visible files";
		}
	};


	static public FileFilter	VisibleDirectories = new FileFilter()
	{
		/*
		 * (non-Javadoc)
		 *
		 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
		 */
		@Override
		public boolean accept(File f)
		{
			return f.isDirectory() && !(f.isHidden() || f.getName().startsWith("."));
		}

		/* (non-Javadoc)
		 * @see javax.swing.filechooser.FileFilter#getDescription()
		 */
		@Override
		public String getDescription()
		{
			return "All visible directories";
		}
	};


	static public FileFilter	METSFiles = new FileFilter()
	{
		/*
		 * (non-Javadoc)
		 *
		 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
		 */
		@Override
		public boolean accept(File f)
		{
			String fileNameLowerCase = f.getName().toLowerCase();
			return	!(f.isHidden() || fileNameLowerCase.startsWith("."))		//	No hidden files and directories
					&& (fileNameLowerCase.startsWith("mets") && fileNameLowerCase.endsWith(".xml"));
		}

		/* (non-Javadoc)
		 *
		 * @see javax.swing.filechooser.FileFilter#getDescription()
		 */
		@Override
		public String getDescription()
		{
			return "METS XML-files";
		}
	};


	static public FileFilter	ZIPs = new FileFilter()
	{
		/*
		 * (non-Javadoc)
		 *
		 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
		 */
		@Override
		public boolean accept(File f)
		{
			String fileName = f.getName();
			return	!(f.isHidden() || fileName.startsWith("."))		//	No hidden files and directories
					&& f.isFile()
					&& fileName.toLowerCase().endsWith(".zip");
		}

		/* (non-Javadoc)
		 * @see javax.swing.filechooser.FileFilter#getDescription()
		 */
		@Override
		public String getDescription()
		{
			return "ZIP-files";
		}
	};


	static public FileFilter	METSFilesOrZIPs = new FileFilter()
	{
		/*
		 * (non-Javadoc)
		 *
		 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
		 */
		@Override
		public boolean accept(File f)
		{
			String fileNameLowerCase = f.getName().toLowerCase();
			return	!(f.isHidden() || fileNameLowerCase.startsWith("."))		//	No hidden files and directories
					&& f.isFile()
					&& (fileNameLowerCase.endsWith(".zip")
						|| (fileNameLowerCase.startsWith("mets") && fileNameLowerCase.endsWith(".xml")));
		}

		/* (non-Javadoc)
		 * @see javax.swing.filechooser.FileFilter#getDescription()
		 */
		@Override
		public String getDescription()
		{
			return "METS- or ZIP-files";
		}
	};


	/**
	 * Accept folders that contain the file mets.xml.
	 * @author denis
	 */
	static public FileFilter	SIPs = new FileFilter()
	{
		@Override
		public boolean accept(File file)
		{
			if (file.isHidden() || file.getName().startsWith("."))		return false;
			if (file.isFile())											return false;

			String[] metsFilesWithin = file.list();
			if (metsFilesWithin == null)								return false;

			for (String f: metsFilesWithin)
				if (f.equalsIgnoreCase("mets.xml"))						return true;

			return false;
		}

		@Override
		public String getDescription()
		{
			return "SIP Folders";
		}
	};


	/**
	 * Accept zip files and folders that contain the file mets.xml.
	 * @author denis
	 */
	static public FileFilter	SIPsOrZIPs = new FileFilter()
	{
		@Override
		public boolean accept(File file)
		{
			if (file.isHidden() || file.getName().startsWith("."))		return false;

			if (file.isFile())
			{
				if (file.getName().toLowerCase().endsWith(".zip"))		return true;
			}
			else
			{
				String[] metsFilesWithin = file.list();
				if (metsFilesWithin == null)							return false;

				for (String f: metsFilesWithin)
					if (f.equalsIgnoreCase("mets.xml"))					return true;
			}

			return false;
		}

		@Override
		public String getDescription()
		{
			return "SIP Folders or ZIP-Files";
		}
	};


	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Instance Public			=======================================================

	//	--------		Interface			-------------------------------------------------------

	@Override
	public boolean accept(File dir, String name)
	{
		return this.accept(new File(dir, name));
	}

}
