/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.gui;

import java.awt.*;

import javax.swing.*;


/**
 * @author denis
 *
 */
public class MultiLineLabel extends Box
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	/**
	 * This is for testing:
	 */
	static public void main(String[] args)
	{
		JFrame f = new JFrame();
		f.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		f.setLayout(new BorderLayout());
		f.add(new JTextArea(), BorderLayout.CENTER);
		f.add(new MultiLineLabel("This is a long label\nwith a second and\nthird row:"
				, Component.RIGHT_ALIGNMENT
				, Component.TOP_ALIGNMENT
			), BorderLayout.WEST);
		f.setMinimumSize(new Dimension(300, 200));
		f.pack();
		f.setLocationRelativeTo(null);
		f.setVisible(true);
	}

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Constructors Public		=======================================================

	/**
	 * Create a multiline-label which is right-top-aligned.
	 * @param label
	 */
	public MultiLineLabel(String label)
	{
		this(label, Component.RIGHT_ALIGNMENT);
	}


	/**
	 * Create a multiline-label which is top-aligned. The horizontal alignment can be configured using the constants Component.*_ALIGNMENT.
	 * @param label
	 */
	public MultiLineLabel(String label, float hAlign)
	{
		this(label, hAlign, Component.TOP_ALIGNMENT);
	}


	/**
	 * Create a multiline-label. The horizontal and vertical alignment can be configured using the constants Component.*_ALIGNMENT.
	 * @param label
	 */
	public MultiLineLabel(String label, float hAlign, float vAlign)
	{
		super(BoxLayout.Y_AXIS);

		if (vAlign == Component.BOTTOM_ALIGNMENT || vAlign == Component.CENTER_ALIGNMENT)		this.add(createGlue());

		String[] labels = label.split("\n");
		for (String s: labels)
		{
			JLabel l = new JLabel(s);
			l.setAlignmentX(hAlign);
			this.add(l);
		}

		if (vAlign == Component.TOP_ALIGNMENT || vAlign == Component.CENTER_ALIGNMENT)			this.add(createGlue());
	}

	//	========	Constructors Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

}
