/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.gui;

import javax.swing.table.*;

/**
 * @author denis
 *
 */
public interface TableModelWithSpecificCellEditorPerRow extends TableModel
{
	/**
	 * This method returns a specific cell editor, depending on the row and column.
	 * @return null if the default cell editor shall be used.
	 */
	public TableCellEditor getCellEditor(int rowIndex, int columnIndex);


	/**
	 * This method returns a specific cell renderer, depending on the row and column.
	 * @param rowIndex
	 * @return null if the default cell renderer shall be used.
	 */
	public TableCellRenderer getCellRenderer(int rowIndex, int columnIndex);
}
