/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.os;

import java.awt.Toolkit;
import java.awt.datatransfer.*;

/**
 * @author denis
 *
 */
public abstract class SystemClipboard
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	static private ClipboardOwnerImpl		Clipboard = new ClipboardOwnerImpl();

	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Constructors Public		=======================================================

	//	========	Constructors Private	=======================================================

	//	========	Static Public			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------

	/**
	 * Set the system clipboard text.
	 * @param string
	 */
	static public void setText(String string)
	{
		Clipboard.setClipboardContents(string);
	}


	/**
	 * Get the system clipboard text.
	 * @param string
	 */
	static public String getText()
	{
		return Clipboard.getClipboardContents();
	}

	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Static Private			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

	static private class ClipboardOwnerImpl implements ClipboardOwner
	{
		/**
		 * Place a String on the clipboard, and make this class the owner of the
		 * Clipboard's contents.
		 */
		public void setClipboardContents(String aString)
		{
			StringSelection stringSelection = new StringSelection(aString);
			Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
			clipboard.setContents(stringSelection, this);
		}


		/**
		 * Get the String residing on the clipboard.
		 *
		 * @return any text found on the Clipboard; if none found, return an
		 *         empty String.
		 */
		public String getClipboardContents()
		{
			String result = "";

			// odd: the Object param of getContents is not currently used
			Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);

			if (contents != null)
				if (contents.isDataFlavorSupported(DataFlavor.stringFlavor))
					try
					{
						result = (String)contents.getTransferData(DataFlavor.stringFlavor);
					}
					catch (Exception ex){}		//	Ignore any exception on purpose

			return result;
		}


		/**
		 * Empty implementation of the ClipboardOwner interface.
		 */
		@Override
		public void lostOwnership(Clipboard aClipboard, Transferable aContents)
		{
			// do nothing
		}
	}

}
