package ch.docuteam.tools.string;

import java.util.List;
import java.util.Vector;


public class Pattern
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Class Initialization	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private Final	=======================================================

	static private final String				RegexMetaCharacters = "[\\^$.|?*+()";

	static private final Character			DefaultWildcardMultiple = '*';
	static private final Character			DefaultWildcardSingle = '?';

	static private final String				RegexWildcardMultiple = ".*";
	static private final String				RegexWildcardSingle = ".";

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	private List<java.util.regex.Pattern>	regexPatterns = new Vector<java.util.regex.Pattern>();

	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Constructors Public		=======================================================

	public Pattern(String... patterns)
	{
		this(DefaultWildcardMultiple, DefaultWildcardSingle, patterns);
	}


	public Pattern(char wildcardMultiple, char wildcardSingle, String... patterns)
	{
		for (String pattern: patterns)
		{
			//	Quote all regex metaCharacters:
			StringBuilder regexPattern = new StringBuilder();
			for (int i = 0; i < pattern.length(); i++)
			{
				Character c = pattern.charAt(i);
				if (c == wildcardMultiple)								regexPattern.append(RegexWildcardMultiple);
				else if (c == wildcardSingle)							regexPattern.append(RegexWildcardSingle);
				else if (RegexMetaCharacters.contains(c.toString()))	regexPattern.append("\\").append(c);	//	Quote
				else													regexPattern.append(c);					//	Copy
			}

			//	Create a compiled regexPattern:
			this.regexPatterns.add(java.util.regex.Pattern.compile(regexPattern.toString()));
		}
	}

	//	========	Constructors Private	=======================================================

	//	========	Static Public			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Static Private			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Public			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------

	/**
	 * Return true if and only if the supplied string matches any of the patterns.
	 * @param match
	 * @return
	 */
	public boolean match(String match)
	{
		for (java.util.regex.Pattern p: this.regexPatterns)
			if (p.matcher(match).matches())		return true;

		return false;
	}

	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

}
