/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.translations;

import java.util.Locale;
import java.util.ResourceBundle;

/**
 * @author denis
 *
 */
public abstract class I18N
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	static public final String[]			AvailableLanguages = new String[] {"de", "en", "fr"};

	//	========	Static Final Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	static private Translator				DefaultTranslator = null;

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	static public void initialize(String language, String translationResourceBasePath)
	{
		DefaultTranslator = new Translator(language, translationResourceBasePath);
	}

	//	========	Static Public			=======================================================

	/**
	 * Return the translated word, or if something goes wrong, the word itself.
	 * Assume that the class has already been initialized.
	 */
	static public String translate(String word)
	{
		if (DefaultTranslator == null)		throw new RuntimeException("I18N was not initialized");

		return DefaultTranslator.translate(word);
	}

	/**
	 * Return the translated word, or if something goes wrong, the word itself. Format any placeholder in the string using the object list.
	 * Assume that the class has already been initialized.
	 */
	static public String translate(String word, Object... objects)
	{
		if (DefaultTranslator == null)		throw new RuntimeException("I18N was not initialized");

		return DefaultTranslator.translate(word, objects);
	}

	//	========	Static Private			=======================================================

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

	/**
	 * Instances of this class actually do the translation.
	 */
	static public class Translator
	{
		protected ResourceBundle				resources = null;


		public Translator(String language, String translationResourceBasePath)
		{
			this.resources = ResourceBundle.getBundle(translationResourceBasePath, new Locale(language));
		}


		/**
		 * Return the translated word, or if something goes wrong, the word itself.
		 */
		public String translate(String word)
		{
			if (this.resources == null)		throw new RuntimeException("This translator was not initialized correctly");

			try
			{
				return this.resources.getString(word);
			}
			catch(Exception x)
			{
				return word;
			}
		}

		/**
		 * Return the translated word, or if something goes wrong, the word itself. Format any placeholder in the string using the object list.
		 */
		public String translate(String word, Object... objects)
		{
			try
			{
				return String.format(this.translate(word), objects);
			}
			catch(Exception x)
			{
				return word;
			}
		}
	}

}
