package ch.docuteam.darc.ead;

import org.dom4j.Node;

import ch.docuteam.darc.common.NodeAbstract;
import ch.docuteam.tools.file.FileUtil;

/**
 * This abstract class is the superclass of <a href="./DID.html">DID</a>, <a href="./C.html">C</a>, and <a href="./ArchDesc.html">ArchDesc</a>.
 *
 * @author denis
 *
 */
public abstract class EADNodeAbstract extends NodeAbstract
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Constructors Public		=======================================================

	//	========	Constructors Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------

	protected void deleteParentElementIfEmpty(String xPath)
	{
		String parentPath = FileUtil.asParentPath(xPath);
		if (parentPath != null)
		{
			Node parentNode = this.element.selectSingleNode(parentPath);
			if (parentNode != null)
			{
				//	Look if the parent has EAD nodes as children - if no, delete it:
				if (parentNode.selectNodes("EAD:*").isEmpty())		parentNode.detach();
			}
		}
	}

	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

}
