/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.exceptions;

import java.util.List;

import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeAbstract.SubmitStatus;

/**
 * @author denis
 *
 */
public class CantSetSubmitStatusRecursiveException extends Exception
{
	private NodeAbstract		node;
	private SubmitStatus		submitStatus;
	private List<String>		rejectMessages;


	public CantSetSubmitStatusRecursiveException(NodeAbstract node, SubmitStatus submitStatus, List<String> rejectMessages)
	{
		this.node = node;
		this.submitStatus = submitStatus;
		this.rejectMessages = rejectMessages;
	}

	//	--------		Accessing			-------------------------------------------------------

	public NodeAbstract getNode()
	{
		return this.node;
	}

	public SubmitStatus getSubmitStatus()
	{
		return this.submitStatus;
	}

	public List<String> getRejectMessages()
	{
		return this.rejectMessages;
	}


	@Override
	public String getMessage()
	{
		StringBuilder result = new StringBuilder("Node: '" + this.node.getPathString() + "' can't set recursively submitStatus: '" + this.submitStatus + "' because of: ");
		for (String s: this.rejectMessages)		result.append("\n").append(s);
		return result.toString();
	}
}
