/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.exceptions;

import java.util.List;

import ch.docuteam.tools.file.exception.FileUtilException;

/**
 * This exception gets thrown when a SIP is being saved but another application is using a file or a folder inside of this SIP.
 *
 * @author denis
 *
 */
public class FileOrFolderIsInUseException extends java.lang.Exception
{
	private List<FileUtilException>		exceptions;
	private String						originalSIPName;
	private String						securityCopySIPName;

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Constructors Public		=======================================================

	public FileOrFolderIsInUseException(List<FileUtilException> exceptions, String originalSIPName, String securityCopySIPName)
	{
		super(exceptions.toString());

		this.exceptions = exceptions;
		this.originalSIPName = originalSIPName;
		this.securityCopySIPName = securityCopySIPName;
	}

	//	--------		Accessing			-------------------------------------------------------

	public List<FileUtilException> getExceptions()
	{
		return this.exceptions;
	}

	public String getOriginalSIPName()
	{
		return this.originalSIPName;
	}

	public String getSecurityCopySIPName()
	{
		return this.securityCopySIPName;
	}


	@Override
	public String getMessage()
	{
		StringBuilder stringBuilder = new StringBuilder();
		for (FileUtilException e: this.exceptions)		stringBuilder.append("\n\t\t").append(e.toString());

		return stringBuilder.toString();
	}

}
