/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.ingest;

import java.util.List;
import java.util.Properties;

import ch.docuteam.darc.mets.Document;

/**
 * This interface contains methods for testing if an AIP package could be created from a SIP, creating an AIP package,
 * and receiving feedback from the AIP receiver.
 *
 * @author denis
 *
 */
public interface AIPCreator
{
	/**
	 * Initialize the implementation.
	 * @param properties A set of properties to initialize the implementation.
	 * @throws Exception In case some mandatory properties are missing.
	 */
	public void initialize(Properties properties) throws Exception;

	/**
	 * Check the document if an AIP could be generated.
	 * @param document The document to be tested
	 * @return A list of error messages. If this list is empty, the AIP could be created.
	 */
	public List<String> checkSubmission(Document document);

	/**
	 * Actually generate the AIP out of the Document and copy it to the destination.
	 * @param document The document to create the AIP from.
	 * @param destination The place where the created AIP should be copied to.
	 * @return Whatever the generator wants to return.
	 * @throws Exception
	 */
	public List<String> generateAIP(Document document) throws Exception;

	/**
	 * Get feedback about the stored AIP. The returning object is completly undefined for now.
	 * @param document
	 * @param destination
	 * @return
	 * @throws Exception
	 */
	public void confirmStorage(Document document) throws Exception;
}
