/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.mets.structmap.NodeAbstract;


/**
 * Interface to specify classes that can be used to validate MetadataElement values.
 *
 * @author denis
 *
 */
public interface MetadataElementValidator
{
	/**
	 * Check the value.
	 * @param value The value to be tested.
	 * @param context The object containing the value, in the case that this validator needs the context of the value to be tested.
	 * @return null if the check is OK, or a message if not.
	 */
	public String check(String value, NodeAbstract context, MetadataElement metadataElement);
}
