/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.mdconfig;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

import ch.docuteam.darc.mets.structmap.NodeAbstract;


/**
 * A MetadataElementValidator that only accepts a string in the standard date format "yyyy-MM-dd".
 *
 * @author denis
 *
 */
public class MetadataElementValidatorDate implements MetadataElementValidator
{
	static private final DateFormat		StandardDateFormat = new SimpleDateFormat("yyyy-MM-dd");

	/* (non-Javadoc)
	 * @see ch.docuteam.darc.ead.DataElementValidator#check(java.lang.String, java.lang.Object)
	 */
	@Override
	public String check(String value, NodeAbstract context, MetadataElement metadataElement)
	{
		if (value == null || value.isEmpty())	return null;

		try
		{
			StandardDateFormat.parse(value);
		}
		catch (ParseException ex)
		{
			return "'" + value + "': Can't convert to date (required format = 'yyyy-mm-dd')";
		}

		return null;
	}

}
