/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.mets.amdsec;

import org.dom4j.Element;

import ch.docuteam.darc.common.NodeAbstract;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.metshdr.Header;


/**
 * This is an abstract class for different DigiprovMD types.
 *
 * @author denis
 *
 */
public abstract class DigiprovAbstract extends NodeAbstract
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	static final protected String		MimeType = "text/xml";

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	static protected String				MDType = "ABSTRACT";

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Constructors Public		=======================================================

	protected DigiprovAbstract() {}


	/**
	 * 	This constructor is used only when a METS-File is being read.
	 */
	protected DigiprovAbstract(AMDSection parent, Element digiprovElement)
	{
		this.document = parent.getDocument();
		this.parent = parent;
		this.element = digiprovElement;

		this.id = digiprovElement.attributeValue("ID");
	}


	/**
	 * 	This constructor is used only when a new digiprov is created programmatically, for a NodeAbstract
	 */
	protected DigiprovAbstract(ch.docuteam.darc.mets.structmap.NodeAbstract node)
	{
		this.document = node.getDocument();
		this.parent = ((Document)this.document).getAMDSection();

		this.id = node.getAdmId();

		((AMDSection)this.parent).addNewDigiprov(this);

		this.element = this.parent.getElement().addElement("METS:digiprovMD")
			.addAttribute("ID", this.id);

		this.document.setIsModified();
	}


	/**
	 * 	This constructor is used only when a new digiprov is created programmatically, for a metshdr.Header
	 */
	protected DigiprovAbstract(Header header)
	{
		this.document = header.getDocument();
		this.parent = ((Document)this.document).getAMDSection();

		this.id = header.getAdmId();

		((AMDSection)this.parent).addNewDigiprov(this);

		this.element = this.parent.getElement().addElement("METS:digiprovMD")
			.addAttribute("ID", this.id);

		//	DON'T mark this document as modified: create this digiprov for header "silently":
//		this.document.setIsModified();
	}

	//	========	Constructors Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------

	/**
	 * This is called only when creating a template out of this METS-File. In this case, files are deleted and their digiprovs must be deleted, too.
	 */
	public void delete()
	{
		((AMDSection)this.parent).deleteDigiprov(this);
		this.element.detach();
		this.document.setIsModified();
	}

	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

}
