/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.premis;

import java.util.List;

import ch.docuteam.tools.string.StringSet;
import ch.docuteam.tools.string.StringSetElement;


/**
 * This class represents a PREMIS event type, one of "Creation", "Submission", "Fixity Check", "Migration", "Renaming", "Path Modification", or "Deletion".
 *
 * @author denis
 *
 */
public class EventType extends StringSetElement
{
	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	static
	{
		new EventType("Creation");
		new EventType("Submission");
		new EventType("Fixity Check");
		new EventType("Migration");
		new EventType("Renaming");
		new EventType("Path Modification");
		new EventType("Deletion");
	}

	//	========	Constructors Private	=======================================================

	private EventType(String value)
	{
		super(value);
	}

	//	========	Static Public			=======================================================

	static public EventType get(String value)
	{
		EventType type = (EventType)StringSet.get(EventType.class, value);
		if (type == null)
			type = new EventType(value);
		return type;
	}


	static public List<? extends StringSetElement> getAll()
	{
		return StringSet.getAll(EventType.class);
	}

}

